define([
    'jquery',
    'Magento_Ui/js/modal/modal',
    'mage/mage',
    'mage/cookies'
], function ($, modal, Mage) {
    'use strict';

    $.widget('geolocation.popup', {
        default_options: {
            type: 'popup',
            responsive: true,
            innerScroll: false,
            modalClass: "country-modal",
            title: false,
            buttons: [
                {
                    text: 'Change shipping country',
                    class: 'action-primary action-accept',
                    click: function () {
                        $('.form-apply-address').submit();
                    }
                },
                {
                    text: 'Continue',
                    class: 'action-secondary action-dismiss',
                    click: function () {
                        this.closeModal();
                    }
                }
            ],
            closed: function() {}
        },

        _init: function (element) {
            if(!this.options.manuallyGeolocation || this.options.forceRedirect) {
                this._differentCountryAjaxRequest(this.options.forceRedirect);
            } else {
                this._shipToAjaxRequest();
            }

            this._openPopupClickAjaxRequest();
        },

        _openPopupClickAjaxRequest: function() {
            var self = this;
            var config = $.extend(this.default_options, this.options);
            this.element.modal(config);

            $(this.options.linkElement).click(function(e) {
                e.preventDefault();

                $.ajax({
                    url: self.options.changeAjaxUrl,
                    type: 'GET',
                    dataType: 'json',
                    beforeSend: function() {
                        $('body').trigger('processStart');
                    },
                    success: function(result) {
                        $(self.options.contentElement).html(result);
                        self.element.modal("openModal");
                        $('body').trigger('processStop');
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        $(self.options.errorElement).html(thrownError);
                        console.log(xhr.status);
                        console.log(thrownError);
                    }
                });

            });
        },

        _differentCountryAjaxRequest: function(forceRedirect) {
            var self = this;

            $.ajax({
                url: self.options.differentCountryAjaxUrl,
                type: 'GET',
                dataType: 'json',
                success: function(result) {
                    if(result) {
                        if(self.options.openPopup && !forceRedirect) {
                            $(self.options.linkElement).trigger('click');
                            $(self.options.errorElement).html($("<strong></strong>")
                                .text("It appears that you are browsing our site in a different shipping country."));
                        } else {
                            $('body').trigger('processStart');
                            Mage.redirect(result);
                        }
                    }
                    self._shipToAjaxRequest();
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    $(self.options.errorElement).html(thrownError);
                    console.log(xhr.status);
                    console.log(thrownError);
                }
            });
        },

        _shipToAjaxRequest: function() {
            var self = this;

            $.ajax({
                url: this.options.shipToAjaxUrl,
                type: 'GET',
                dataType: 'json',
                success: function(result) {
                    $(self.options.countryElement).replaceWith(result);
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    console.log(xhr.status);
                    console.log(thrownError);
                }
            });
        }

    });

    return $.geolocation.popup;
});

