require([
    'jquery',
    'Magento_Ui/js/modal/modal',
    'mage/url',
    'mage/translate'
], function ($, modal, Url) {
    var path = '';
    var country_name = '';
    var selected = -1;

    $(".form-address-edit").append(
        '<div id="change-country-alert" style="display: none;">\n' +
            'The availability of items, prices, shippings methods, payment methods and currencies will be updated based on the new destination.\n' +
        '</div>'
    );

    $('#change-country-alert').modal({
        title: 'Do you want change country in ' + country_name,
        type: 'popup',
        responsive: true,
        innerScroll: false,
        modalClass: 'change-country-modal',
        buttons: [
            {
                text: 'Change country',
                class: 'action-primary action-accept',
                click: function () {
                    document.location = path;
                }
            },
            {
                text: 'Cancel',
                class: 'action-secondary action-dismiss',
                click: function () {
                    this.closeModal();

                }
            }
        ],
	    closed: function (){
            $(".form-address-edit select[name='country_id'] option").eq(selected).prop('selected', true);
	    }
    });

    selected = $(".form-address-edit select[name='country_id'] option:selected").index();

    $("body").on("change", ".form-address-edit select[name='country_id']", function (ev) {
        if (ev.originalEvent) {
            var country_id = $(this).val(),
                country_name = $(":selected", this).text();

            // path = Url.build('/geolocation/index/apply') + '?country_id=' + country_id;
            path = '/geolocation/index/apply' + '?country_id=' + country_id;
            $('.change-country-modal .modal-title').text('Do you want change country in ' + country_name);
            $('#change-country-alert').modal('openModal');
        }
    });
});
