<?php
/**
 * ApplyToQuote
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Geolocation\Observer;

/**
 * Class ApplyToQuote
 *
 * @package Drop\Geolocation\Observer
 */
class ApplyToQuote implements \Magento\Framework\Event\ObserverInterface
{

    /**
     * @var \Drop\Geolocation\Helper\Bots
     */
    protected $session;
    /**
     * @var \Drop\Geolocation\Model\Apply
     */
    protected $apply;

    /**
     * ApplyToQuote constructor
     *
     * @param \Drop\Geolocation\Model\Session $session
     * @param \Drop\Geolocation\Model\Apply $apply
     */
    public function __construct(
        \Drop\Geolocation\Model\Session $session,
        \Drop\Geolocation\Model\Apply $apply
    ) {
        $this->session = $session;
        $this->apply = $apply;
    }

    /**
     * @param \Magento\Framework\Event\Observer $observer
     * @return ApplyToQuote
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $countryId = $this->session->getCountryId();
        if(empty($countryId)) {
            return $this;
        }

        $quoteAddress = $observer->getEvent()->getData('quote_address');
        if(!$quoteAddress) {
            return $this;
        }

        $quoteAddress->setCountryId($countryId);

        return $this;
    }

}
