<?php
/**
 * Session
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Geolocation\Model;

use Magento\Store\Model\ScopeInterface;

/**
 * Class Session
 *
 * Setters
 *
 * @method $this setData(string $key, mixed $value)
 * @method $this setCountryId(int $countryId)
 * @method $this setLocale(string $locale)
 * @method $this setUserIsManuallyGeolocated(boolean)
 *
 * Getters
 *
 * @method int getCountryId()
 * @method string getLocale()
 * @method boolean getUserIsManuallyGeolocated()
 *
 * @package Drop\Geolocation\Model\
 */
class Session extends \Magento\Framework\Session\SessionManager
{

    /**
     * @var \Drop\Geolocation\Helper\GeoIp
     */
    private $geoIpHelper;
    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $url;
    /**
     * @var \Magento\Framework\App\ResponseFactory
     */
    private $responseFactory;
    /**
     * @var \Drop\Geolocation\Helper\Locale
     */
    private $localeHelper;
    /**
     * @var \Drop\Geolocation\Helper\Data
     */
    private $helper;
    /**
     * @var \Drop\Geolocation\Logger\Logger
     */
    private $logger;

    /**
     * Session constructor
     *
     * @param \Magento\Framework\App\Request\Http $request
     * @param \Magento\Framework\Session\SidResolverInterface $sidResolver
     * @param \Magento\Framework\Session\Config\ConfigInterface $sessionConfig
     * @param \Magento\Framework\Session\SaveHandlerInterface $saveHandler
     * @param \Magento\Framework\Session\ValidatorInterface $validator
     * @param \Magento\Framework\Session\StorageInterface $storage
     * @param \Magento\Framework\Stdlib\CookieManagerInterface $cookieManager
     * @param \Magento\Framework\Stdlib\Cookie\CookieMetadataFactory $cookieMetadataFactory
     * @param \Magento\Framework\App\State $appState
     * @param \Drop\Geolocation\Helper\Data $helper
     * @param \Drop\Geolocation\Helper\GeoIp $geoIpHelper
     * @param \Drop\Geolocation\Helper\Locale $localeHelper
     * @param \Magento\Framework\UrlInterface $url
     * @param \Magento\Framework\App\ResponseFactory $responseFactory
     * @param \Drop\Geolocation\Logger\Logger $logger
     * @throws \Magento\Framework\Exception\SessionException
     */
    public function __construct(
        \Magento\Framework\App\Request\Http $request,
        \Magento\Framework\Session\SidResolverInterface $sidResolver,
        \Magento\Framework\Session\Config\ConfigInterface $sessionConfig,
        \Magento\Framework\Session\SaveHandlerInterface $saveHandler,
        \Magento\Framework\Session\ValidatorInterface $validator,
        \Magento\Framework\Session\StorageInterface $storage,
        \Magento\Framework\Stdlib\CookieManagerInterface $cookieManager,
        \Magento\Framework\Stdlib\Cookie\CookieMetadataFactory $cookieMetadataFactory,
        \Magento\Framework\App\State $appState,
        \Drop\Geolocation\Helper\Data $helper,
        \Drop\Geolocation\Helper\GeoIp $geoIpHelper,
        \Drop\Geolocation\Helper\Locale $localeHelper,
        \Magento\Framework\UrlInterface $url,
        \Magento\Framework\App\ResponseFactory $responseFactory,
        \Drop\Geolocation\Logger\Logger $logger
    ) {
        parent::__construct(
            $request,
            $sidResolver,
            $sessionConfig,
            $saveHandler,
            $validator,
            $storage,
            $cookieManager,
            $cookieMetadataFactory,
            $appState
        );

        $this->helper = $helper;
        $this->geoIpHelper = $geoIpHelper;
        $this->localeHelper = $localeHelper;
        $this->url = $url;
        $this->responseFactory = $responseFactory;
        $this->logger = $logger;
    }

    /**
     * Geolocation country_id calculation
     * @return $this|bool
     * @throws \MaxMind\Db\Reader\InvalidDatabaseException
     */
    public function getGeolocatedCountryId() {
        $ip = $this->geoIpHelper->getIp();
        if (!$ip) {
            return false;
        }

        $countryId = $this->geoIpHelper->getCountryIdByIp($ip);

//        $countryId = ''; //Testing fallback
//        $countryId = 'DE'; //Testing pourpose

        return $countryId;
    }

    /**
     * Geolocation country_id setter
     * @return $this
     * @throws \MaxMind\Db\Reader\InvalidDatabaseException
     */
    public function setGeolocatedCountryId() {
        $countryId = $this->getGeolocatedCountryId();
        if (!$countryId) {
            return false;
        }

//        $countryId = ''; //Testing fallback
//        $countryId = 'DE'; //Testing pourpose

        $this->setCountryId($countryId);
        return $this;
    }

    /**
     * Browser language calculation
     * @return $this
     */
    public function getBrowserLocale() {
        $browserLanguage = $this->localeHelper->getBrowserLanguage();
        return $this->localeHelper->getMagentoLocaleByBrowserLanguage($browserLanguage);
    }

    /**
     * Browser language setter
     * @return $this
     */
    public function setBrowserLocale() {
        $locale = $this->getBrowserLocale();
        $this->setLocale($locale);
        return $this;
    }
}
