<?php
/**
 * RemoteAddress
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Geolocation\Model;

use \Zend\Stdlib\Parameters;
use Magento\Framework\App\RequestInterface;

class RemoteAddress {

    /**
     * Request object
     *
     * @var RequestInterface
     */
    protected $request;

    /**
     * RemoteAddress constructor
     *
     * @param RequestInterface $httpRequest
     */
    public function __construct(
        RequestInterface $httpRequest
    ) {
        $this->request = $httpRequest;
    }


    /**
     * Load Balancer ip FIX
     *
     * @param \Magento\Framework\HTTP\PhpEnvironment\RemoteAddress $subject
     * @param bool $ipToLong
     * @return bool
     */
    public function beforeGetRemoteAddress(\Magento\Framework\HTTP\PhpEnvironment\RemoteAddress $subject, $ipToLong = false)
    {
        $httpXForwardedFor = $this->request->getServer('HTTP_X_FORWARDED_FOR');
        if (!empty($httpXForwardedFor) && (strpos($httpXForwardedFor, ',') !== false)) {
            $ips = explode(',', $httpXForwardedFor);
            $userIp = trim($ips[0]);
            if(!empty($userIp)){
                $_SERVER['HTTP_X_FORWARDED_FOR'] = $userIp;
                $_SERVER['REMOTE_ADDR'] = $userIp;
                $this->request->setServer(new Parameters($_SERVER));
            }
        }

        return $ipToLong;
    }

}
