<?php

namespace Drop\Geolocation\Model;

use Magento\Framework\App\Action\AbstractAction;
use Magento\Framework\App\RequestInterface;

/**
 * Plugin for Magento\Framework\App\Http\Context to create new page cache based on Geolocation Country
 */
class GeolocationContext
{

    const GEO_COOKIE_NAME = 'current_country_store';

    /**
     * Geolocation session
     *
     * @var \Drop\Geolocation\Model\Session
     */
    private $session;

    /**
     * @var \Drop\Geolocation\Model\Apply
     */
    private $httpContext;

    /**
     * @var \Magento\Framework\App\Http\Context
     */
    private $apply;

    /**
     * @param \Drop\Geolocation\Model\Session $geoSession
     * @param \Drop\Geolocation\Model\Apply $apply
     * @param \Magento\Framework\App\Http\Context $httpContext
     */
    public function __construct(
        \Drop\Geolocation\Model\Session $session,
        \Drop\Geolocation\Model\Apply $apply,
        \Magento\Framework\App\Http\Context $httpContext
    ) {
        $this->session = $session;
        $this->apply = $apply;
        $this->httpContext = $httpContext;
    }

//    public function beforeDispatch(
//        AbstractAction $subject,
//        RequestInterface $request
//    ) {
//        if ($this->isAlreadySet()) {
//            //If required store related value were already set for
//            //HTTP processors then just continuing as we were.
//            return;
//        }
//
//        $countryId = $this->session->getCountryId();
//        if(empty($countryId)) {
//            $this->session->setGeolocatedCountryId();
//            $countryId = $this->session->getCountryId();
//        }
//
//        $locale = $this->session->getLocale();
//        if(empty($locale)) {
//            $this->session->setBrowserLocale();
//            $locale = $this->session->getLocale();
//        }
//
//        $currentCountryStore = $this->apply->getStoreByCountryAndLocale($countryId, $locale);
//        if(empty($currentCountryStore)) {
//            //Disabled Country
//            $this->session->redirectToFallback();
//            $currentCountryStore = $this->getFallbackContextValue();
//        }
//
//        $this->updateContext($currentCountryStore->getCode());
//    }
//
//    /**
//     * @todo: Cache store list
//     */
//    private function getFallbackContextValue() {
//        $stores = $this->apply->getStoreList();
//        return $stores[key($stores)];
//    }
//
//    /**
//     * Update context accordingly to the country_id found.
//     *
//     * @param StoreInterface $store
//     */
//    private function updateContext($storeCode)
//    {
//        $this->httpContext->setValue(
//            self::GEO_COOKIE_NAME,
//            $storeCode,
//            $this->getFallbackContextValue()->getCode()
//        );
//    }
//
//     /**
//     * Check if there a need to find the current store.
//     *
//     * @return bool
//     */
//    private function isAlreadySet(): bool
//    {
//        return $this->httpContext->getValue(self::GEO_COOKIE_NAME) !== null;
//    }

}
