<?php
/**
 * Customer
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Geolocation\Model;

class Customer extends \Magento\Customer\Model\Customer {


    /**
     * Override getAddressesCollection() to show only address with the current country code only in the checkout page
     * @return \Magento\Customer\Model\ResourceModel\Address\Collection|\Magento\Framework\Data\Collection\AbstractDb
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getAddressesCollection()
    {
        if ($this->_addressesCollection === null) {
            $this->_addressesCollection = $this->getAddressCollection()
                                            ->setCustomerFilter($this)
                                            ->addAttributeToSelect('*');

            // Add country_id filter to addresses collection
            $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            $countryId = $objectManager->create('\Drop\Geolocation\Model\Session')->getCountryId();
            if(!empty($countryId)) {
                $this->_addressesCollection
                    ->addFieldToFilter('country_id', ["eq"=> $countryId]);
            }

            foreach ($this->_addressesCollection as $address) {
                $address->setCustomer($this);
            }
        }

        return $this->_addressesCollection;
    }
}
