<?php

namespace Drop\Geolocation\Model\Config\Source;

use \Magento\ImportExport\Model\Import\ErrorProcessing\ProcessingErrorAggregatorInterface;

class VarnishBehavior implements \Magento\Framework\Option\ArrayInterface
{
    
    const BEHAVIOR_POPUP = 'popup';
    const BEHAVIOR_REDIRECT = 'redirect';

    /**
     * Options array
     *
     * @var array
     */
    protected $_options;

    /**
     * Return options array
     *
     * @return array
     */
    public function toOptionArray()
    {
        if (!$this->_options) {
            $this->_options = [
                ['value' => self::BEHAVIOR_POPUP, 'label' => __('Open Popup')],
                ['value' => self::BEHAVIOR_REDIRECT, 'label' => __('User Redirect')]
            ];
        }

        return $this->_options;
    }
}
