<?php
/**
 * Bots
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Geolocation\Helper;

use \Magento\Store\Model\ScopeInterface;

/**
 * @todo Forbidden Bots management, Forbidden IPs Management
 *
 *
 * Class Bots
 * @package Drop\Geolocation\Helper
 */
class Bots extends \Magento\Framework\App\Helper\AbstractHelper
{

    const XML_PATH_WEB_BROWSER_CAPABILITIES_BOTS = 'geolocation/browser_capabilities/bots';

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * Bots constructor
     *
     * @param \Magento\Framework\App\Helper\Context $context
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Store\Model\StoreManagerInterface $storeManager
    ) {
        parent::__construct($context);

        $this->storeManager = $storeManager;
        $this->scopeConfig = $context->getScopeConfig();
    }

    /**
     * Get bots from configuration
     *
     * @param null $store
     * @return array
     */
    public function getBots($store = null)
    {
        $bots  = [];
        $_bots = explode(',', $this->scopeConfig->getValue(self::XML_PATH_WEB_BROWSER_CAPABILITIES_BOTS, ScopeInterface::SCOPE_STORE, $store));
        foreach ($_bots as $_bot) {
            $bot = trim($_bot);
            if ($bot) {
                array_push($bots, $bot);
            }
        }
        return $bots;
    }

    /**
     * Check if HTTP client is bot
     *
     * @return bool
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function isBot()
    {
        $userAgent = $this->_httpHeader->getHttpUserAgent();
        foreach ($this->getBots($this->storeManager->getStore()) as $bot) {
            if (stristr($userAgent, $bot) !== false) {
                return true;
            }
        }
        return false;
    }

}
