<?php
/**
 * Apply
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Geolocation\Helper;

use \Magento\Store\Model\ScopeInterface;

/**
 * @todo Forbidden Bots management, Forbidden IPs Management
 *
 *
 * Class Apply
 * @package Drop\Geolocation\Helper
 */
class Apply extends \Magento\Framework\App\Helper\AbstractHelper
{

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;
    /**
     * @var \Drop\Geolocation\Helper\Data
     */
    protected $helper;

    protected $storeList;

    /**
     * Apply constructor
     *
     * @param \Magento\Framework\App\Helper\Context $context
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Drop\Geolocation\Helper\Data $helper
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Drop\Geolocation\Helper\Data $helper
    ) {
        parent::__construct($context);

        $this->storeManager = $storeManager;
        $this->helper = $helper;
    }


    /**
     * Store list caching
     *
     * @return \Magento\Store\Api\Data\StoreInterface[]
     */
    public function getStoreList() {
        if(!isset($this->storesList)) {
            $this->storeList = $this->storeManager->getStores();
        }
        return $this->storeList;
    }

    /**
     * @return mixed
     */
    public function getCurrentStoreCode() {
        return $this->storeManager->getStore()->getCode();
    }

    /**
     *
     * @param $url
     * @return mixed|string
     */
    public function getStoreCodeFromUrl($url)
    {
        foreach($this->getStoreList() as $store) {
            $storeCode =  $store->getCode();
            if((strpos($url, '/' . $storeCode . '/') !== false)) {
                return $storeCode;
            }
        }
        return $this->getCurrentStoreCode();
    }

    /**
     * @param $url
     * @return bool
     */
    public function getStoreCodeIsOnUrl($url) {
        foreach($this->getStoreList() as $store) {
            $storeCode =  $store->getCode();
            if((strpos($url, '/' . $storeCode . '/') !== false)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Default store view code
     *
     * @return mixed
     */
    public function getDefaultStoreCode() {
        return $this->storeManager->getDefaultStoreView()->getCode();
    }

    /**
     * Remove query string from urls
     *
     * @param $url
     * @return bool|string
     */
    public function removeQueryStringFromUrl($url)
    {
        $pos = strpos($url, '?');
        if ($pos) {
            $url = substr($url, 0, $pos);
        }
        return $url;
    }

    /**
     * Remove base_url from urls
     *
     * @param $url
     * @return bool|string
     */
    public function removeBaseUrlFromUrl($url)
    {
        $baseUrl = $this->helper->getBaseUrl();
        return substr($url, strlen($baseUrl));
    }

    /**
     * Remove store_code from urls
     *
     * @param $url
     * @return bool|string
     */
    public function removeStoreCodeFromUrl($url)
    {
        foreach($this->getStoreList() as $store) {
            $storeCode =  $store->getCode();
            if((strpos($url, $storeCode) === 0)) {
                $url = substr($url, strlen($storeCode));
                break;
            }
        }
        return $url;
    }

}
