<?php

namespace Drop\Geolocation\Controller\Rewrite\Store;

use Magento\Framework\App\Action\Context;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Api\StoreRepositoryInterface;
use Magento\Store\Api\StoreResolverInterface;
use Magento\Store\Model\StoreResolver;
use Magento\Framework\Session\SidResolverInterface;
use Magento\Framework\Session\Generic as Session;

class Redirect extends \Magento\Store\Controller\Store\Redirect
{
    /**
     * @var StoreRepositoryInterface
     */
    private $storeRepository;

    /**
     * @var StoreResolverInterface
     */
    private $storeResolver;

    /**
     * @var SidResolverInterface
     */
    private $sidResolver;

    /**
     * @var Session
     */
    private $session;

    /**
     * @var \Drop\Geolocation\Model\Session
     */
    private $geoSession;

    /**
     * @var \Drop\Geolocation\Helper\Data
     */
    private $helper;

    /**
     * @param Context $context
     * @param StoreRepositoryInterface $storeRepository
     * @param StoreResolverInterface $storeResolver
     * @param Session $session
     * @param SidResolverInterface $sidResolver
     * @param \Drop\Geolocation\Model\Session $geoSession
     * @param \Drop\Geolocation\Helper\Data $helper
     */
    public function __construct(
        Context $context,
        StoreRepositoryInterface $storeRepository,
        StoreResolverInterface $storeResolver,
        Session $session,
        SidResolverInterface $sidResolver,
        \Drop\Geolocation\Model\Session $geoSession,
        \Drop\Geolocation\Helper\Data $helper
    ) {
        $this->storeRepository = $storeRepository;
        $this->storeResolver = $storeResolver;
        $this->session = $session;
        $this->sidResolver = $sidResolver;
        $this->geoSession = $geoSession;
        $this->helper = $helper;

        parent::__construct($context, $storeRepository, $storeResolver, $session, $sidResolver);
    }

    /**
     * @return ResponseInterface|\Magento\Framework\Controller\ResultInterface
     * @throws NoSuchEntityException
     */
    public function execute()
    {
        /** @var \Magento\Store\Model\Store $currentStore */
        $currentStore = $this->storeRepository->getById($this->storeResolver->getCurrentStoreId());
        $targetStoreCode = $this->_request->getParam(StoreResolver::PARAM_NAME);
        $fromStoreCode = $this->_request->getParam('___from_store');
        $error = null;

        if ($targetStoreCode === null) {
            return $this->_redirect($currentStore->getBaseUrl());
        }

        try {
            /** @var \Magento\Store\Model\Store $targetStore */
            $fromStore = $this->storeRepository->get($fromStoreCode);
        } catch (NoSuchEntityException $e) {
            $error = __('Requested store is not found');
        }

        if ($error !== null) {
            $this->messageManager->addErrorMessage($error);
            $this->_redirect->redirect($this->_response, $currentStore->getBaseUrl());
        } else {
            $encodedUrl = $this->_request->getParam(\Magento\Framework\App\ActionInterface::PARAM_NAME_URL_ENCODED);

            $query = [
                '___from_store' => $fromStore->getCode(),
                StoreResolverInterface::PARAM_NAME => $targetStoreCode,
                \Magento\Framework\App\ActionInterface::PARAM_NAME_URL_ENCODED => $encodedUrl,
            ];

            if ($this->sidResolver->getUseSessionInUrl()) {
                // allow customers to stay logged in during store switching
                $sidName = $this->sidResolver->getSessionIdQueryParam($this->session);
                $query[$sidName] = $this->session->getSessionId();
            }

            $arguments = [
                '_nosid' => true,
                '_query' => $query
            ];


            //Set locale to geolocation session
            $targetLocaleCode = $this->helper->getDefaultLocale(\Magento\Store\Model\ScopeInterface::SCOPE_STORE, $targetStoreCode);
            if(empty($targetLocaleCode)) {
                return $this->_redirect($currentStore->getBaseUrl());
            }

            $this->geoSession->setLocale($targetLocaleCode);


            $this->_redirect->redirect($this->_response, 'stores/store/switch', $arguments);
        }
    }
}
