<?php
/**
 * Fallback
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Geolocation\Controller\Index;

class Fallback extends \Magento\Framework\App\Action\Action
{
    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    protected $pageFactory;
    /**
     * @var \Drop\Geolocation\Model\Session
     */
    private $session;
    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $urlInterface;
    /**
     * @var \Magento\Framework\App\ResponseFactory
     */
    private $responseFactory;
    /**
     * @var \Magento\Framework\App\Response\RedirectInterface
     */
    private $redirect;
    /**
     * @var \Drop\Geolocation\Helper\Data
     */
    private $helper;
    /**
     * @var \Magento\Directory\Model\AllowedCountries
     */
    private $allowedCountries;

    /**
     * Fallback constructor.
     *
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Magento\Framework\View\Result\PageFactory $pageFactory
     * @param \Drop\Geolocation\Model\Session $session
     * @param \Drop\Geolocation\Helper\Data $helper
     * @param \Magento\Framework\UrlInterface $urlInterface
     * @param \Magento\Framework\App\ResponseFactory $responseFactory
     * @param \Magento\Framework\App\Response\RedirectInterface $redirect
     * @param \Magento\Framework\Message\ManagerInterface $messageManager
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $pageFactory,
        \Drop\Geolocation\Model\Session $session,
        \Drop\Geolocation\Helper\Data $helper,
        \Magento\Framework\UrlInterface $urlInterface,
        \Magento\Framework\App\ResponseFactory $responseFactory,
        \Magento\Framework\App\Response\RedirectInterface $redirect,
        \Magento\Framework\Message\ManagerInterface $messageManager,
        \Magento\Directory\Model\AllowedCountries $allowedCountries
    ) {
        parent::__construct($context);

        $this->pageFactory = $pageFactory;
        $this->session = $session;
        $this->helper = $helper;
        $this->urlInterface = $urlInterface;
        $this->responseFactory = $responseFactory;
        $this->redirect = $redirect;
        $this->messageManager = $messageManager;
        $this->allowedCountries = $allowedCountries;
    }

    public function execute()
    {
        $allowedCountries = $this->allowedCountries->getAllowedCountries();

        if(!empty($this->session->getCountryId())
            && !empty($this->session->getLocale())
            && in_array($this->session->getCountryId(), $allowedCountries)
        ) {
            $refererUrl = $this->redirect->getRefererUrl();
            if($this->helper->getIsGeolocationOrStoreSwitcherUrl($refererUrl)) {
                $refererUrl = $this->urlInterface->getRedirectUrl('/');
            }
            $this->session->setUserIsManuallyGeolocated(true);
            $this->responseFactory->create()->setRedirect($refererUrl)->sendResponse();
            exit;
        }

        $this->messageManager->addErrorMessage('You must select a shipping country and a navigation language');
        return $this->pageFactory->create();
    }

}
