<?php
/**
 * Change
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Geolocation\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;

class Change extends Action
{
    /**
     * @var \Magento\Framework\Controller\Result\Json
     */
    protected $resultJson;

    /**
     * @var \Magento\Framework\App\Request\Http
     */
    protected $request;

    /**
     * @var \Drop\Geolocation\Block\Geolocation
     */
    protected $geolocationBlock;

    /**
     * @var \Drop\Geolocation\Model\Session
     */
    protected $session;

    /**
     * @var PageFactory
     */
    protected $_resultPageFactory;

    /**
     * Change constructor.
     * 
     * @param Context $context
     * @param \Drop\Geolocation\Block\Geolocation $geolocationBlock
     * @param \Magento\Framework\Controller\Result\Json $resultJson
     * @param \Drop\Geolocation\Model\Session $session
     */
    public function __construct(
        Context $context,
        \Drop\Geolocation\Block\Geolocation $geolocationBlock,
        \Drop\Geolocation\Model\Session $session,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Framework\Controller\Result\Json $resultJson
    )
    {
        parent::__construct($context);

        $this->request = $context->getRequest();
        $this->geolocationBlock = $geolocationBlock;
        $this->resultJson = $resultJson;
        $this->session = $session;
        $this->_resultPageFactory = $resultPageFactory;
    }


    /**
     * @return bool|\Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\Result\Json|\Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        if(!$this->request->isAjax()) {
            return false;
        }

        $block = $this->_resultPageFactory->create()->getLayout()
            ->createBlock('Drop\Geolocation\Block\Geolocation')
            ->setTemplate('Drop_Geolocation::geolocation/select-shipping-country.phtml')
            ->toHtml();

        /** @var \Magento\Framework\Controller\Result\Json $resultJson */
        $resultJson = $this->resultFactory->create(\Magento\Framework\Controller\ResultFactory::TYPE_JSON);
        $resultJson->setData($block);
        return $resultJson;
    }

}
