<?php
/**
 * ShippingLayoutProcessor
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Geolocation\Block\Checkout\Address\Fields;

use Magento\Checkout\Block\Checkout\LayoutProcessorInterface;

class ShippingLayoutProcessor implements LayoutProcessorInterface
{

    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $urlInterface;

    /**
     * ShippingLayoutProcessor constructor.
     * 
     * @param \Magento\Framework\UrlInterface $urlInterface
     */
    public function __construct(
        \Magento\Framework\UrlInterface $urlInterface
    )
    {
        $this->urlInterface = $urlInterface;
    }

    /**
     * Adding custom component to country_id checkout shipping field
     * @param array $result
     * @return array
     */
    public function process($result)
    {
        $result
        ['components']
        ['checkout']
        ['children']
        ['steps']
        ['children']
        ['shipping-step']
        ['children']
        ['shippingAddress']
        ['children']
        ['shipping-address-fieldset']
        ['children']
        ['country_id']
        ['component'] = 'Drop_Geolocation/js/view/form/element/country';

        return $result;
    }

}
