define([
    "jquery"
], function($) {
    "use strict";

    $.widget('geolocation.localeJs', {

        _create: function() {
            this._bind();
        },

        _bind: function() {
            var self = this;

            if(this.options.triggerImmediately) {
                self._ajaxSubmit();
            }

            $('body').on('change', this.options.triggerElement, function() {
                self._ajaxSubmit();
            });
        },

        _ajaxSubmit: function() {
            var self = this;

            $.ajax({
                url: this.options.localeAjaxUrl,
                data: {'country_id': $(this.options.triggerElement).val()},
                type: 'GET',
                dataType: 'json',
                beforeSend: function() {
                    $('body').trigger('processStart');
                },
                success: function(result) {
                     $(self.options.localeElement).children('.control').empty().append(result);
                     if(result == null) {
                         $(self.options.localeElement).hide();
                     } else {
                         $(self.options.localeElement).show();
                     }
                    $('body').trigger('processStop');
                }
            });
        },

    });

    return $.geolocation.localeJs;
});
