<?php
/**
 * ShipTo
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Geolocation\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Store\Model\ScopeInterface;

class ShipTo extends Action
{
    /**
     * @var \Magento\Framework\Controller\Result\Json
     */
    protected $resultJson;

    /**
     * @var \Magento\Framework\App\Request\Http
     */
    protected $request;

    /**
     * @var \Drop\Geolocation\Model\Session
     */
    protected $session;
    /**
     * @var \Drop\Geolocation\Helper\Data
     */
    private $helper;
    /**
     * @var \Drop\Geolocation\Helper\Locale
     */
    private $localeHelper;

    /**
     * ShipTo constructor
     *
     * @param Context $context
     * @param \Drop\Geolocation\Model\Session $session
     * @param \Drop\Geolocation\Helper\Data $helper
     * @param \Drop\Geolocation\Helper\Locale $localeHelper
     * @param \Magento\Framework\Controller\Result\Json $resultJson
     */
    public function __construct(
        Context $context,
        \Drop\Geolocation\Model\Session $session,
        \Drop\Geolocation\Helper\Data $helper,
        \Drop\Geolocation\Helper\Locale $localeHelper,
        \Magento\Framework\Controller\Result\Json $resultJson
    )
    {
        parent::__construct($context);

        $this->request = $context->getRequest();
        $this->session = $session;
        $this->helper = $helper;
        $this->localeHelper = $localeHelper;
        $this->resultJson = $resultJson;
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface|void
     */
    public function execute()
    {
        if(!$this->request->isAjax()) {
            return false;
        }

        $countryId = $this->session->getCountryId();
        if(empty($countryId)) {
            $countryId = $this->helper->getDefaultCountryId(ScopeInterface::SCOPE_STORE);
        }
        
        /** @var \Magento\Framework\Controller\Result\Json $resultJson */
        $resultJson = $this->resultFactory->create(\Magento\Framework\Controller\ResultFactory::TYPE_JSON);
        $resultJson->setData($countryId);
        return $resultJson;
    }

}
