<?php
/**
 * Apply
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Geolocation\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Store\Model\ScopeInterface;

class Apply extends Action
{

    /**
     * @var \Magento\Framework\App\Request\Http
     */
    protected $request;
    /**
     * @var \Drop\Geolocation\Model\Apply
     */
    private $apply;
    /**
     * @var \Drop\Geolocation\Model\Session
     */
    private $session;
    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $urlInterface;
    /**
     * @var \Magento\Framework\App\ResponseInterface
     */
    private $response;
    /**
     * @var \Drop\Geolocation\Helper\Data
     */
    private $helper;
    /**
     * @var \Magento\Framework\App\Response\RedirectInterface
     */
    private $redirect;
    /**
     * @var \Magento\Framework\Session\Config\ConfigInterface
     */
    private $sessionConfig;
    /**
     * @var \Magento\Checkout\Model\SessionFactory
     */
    private $checkoutSessionFactory;
    /**
     * @var \Drop\Geolocation\Logger\Logger
     */
    private $logger;

    /**
     * Apply constructor.
     *
     * @param Context $context
     * @param \Drop\Geolocation\Model\Apply $apply
     * @param \Drop\Geolocation\Model\Session $session
     * @param \Magento\Checkout\Model\SessionFactory $checkoutSessionFactory
     * @param \Magento\Framework\UrlInterface $urlInterface
     * @param \Magento\Framework\App\Response\RedirectInterface $redirect
     * @param \Magento\Framework\Session\Config\ConfigInterface $sessionConfig
     * @param \Drop\Geolocation\Helper\Data $helper
     * @param \Drop\Geolocation\Logger\Logger $logger
     */
    public function __construct(
        Context $context,
        \Drop\Geolocation\Model\Apply $apply,
        \Drop\Geolocation\Model\Session $session,
        \Magento\Checkout\Model\SessionFactory $checkoutSessionFactory,
        \Magento\Framework\UrlInterface $urlInterface,
        \Magento\Framework\App\Response\RedirectInterface $redirect,
        \Magento\Framework\Session\Config\ConfigInterface $sessionConfig,
        \Drop\Geolocation\Helper\Data $helper,
        \Drop\Geolocation\Logger\Logger $logger
    )
    {
        parent::__construct($context);
        
        $this->request = $context->getRequest();
        $this->response = $context->getResponse();
        $this->apply = $apply;
        $this->session = $session;
        $this->checkoutSessionFactory = $checkoutSessionFactory;
        $this->urlInterface = $urlInterface;
        $this->helper = $helper;
        $this->redirect = $redirect;
        $this->sessionConfig = $sessionConfig;
        $this->logger = $logger;
    }

    /**
     * @return bool
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function execute()
    {
        $this->logger->error("*****start execute: countryId: " . $this->session->getCountryId() . " locale: " . $this->session->getLocale());
        $this->logger->error("start execute - get params: country_id: " . $this->request->getParam('country_id') . " locale:" . $this->request->getParam('locale'));

        if ($this->request->isAjax()) {
            return false;
        }

        $countryId = $this->request->getParam('country_id');
        if (empty($countryId)) {
            $this->logger->error("!!!!!!!!!!!empty country id");
            $this->session->setUserIsManuallyGeolocated(false);
            $this->response->setRedirect($this->urlInterface->getUrl(\Drop\Geolocation\Helper\Data::FALLBACK_PAGE_URL))->sendResponse();
            exit;
        }

        $locale = $this->request->getParam('locale');
        if (empty($locale)) {
            $this->logger->error("!!!!!!!!!!!empty locale");
            $locale = $this->session->getLocale();
            if (empty($locale)) {
                $this->response->setRedirect($this->urlInterface->getUrl(\Drop\Geolocation\Helper\Data::FALLBACK_PAGE_URL))->sendResponse();
                exit;
            }
        }

        if ($this->session->getLocale() !== $this->request->getParam('locale')) {
            $locale = $this->session->getLocale();
        }

        $oldSessionCountryId = $this->session->getCountryId();

        $this->session
            ->setCountryId($countryId)
            ->setLocale($locale)
            ->setUserIsManuallyGeolocated(true);

        if ($countryId != $oldSessionCountryId) {
            $this->updateQuoteCountry($countryId);
        }

        $refererUrl = $this->redirect->getRefererUrl();
        $rightPath = $this->apply->getUrlToRightStoreView($countryId, $locale, $refererUrl);
        $this->logger->error("refererUrl: " . $refererUrl);
        $this->logger->error(" rightPath: " . $rightPath) ;
        $this->logger->error(" countryId: " . $countryId . " locale: " . $locale);
        if (empty($rightPath)) {
            $this->logger->error("!!!!!!!!!!!empty rightPath");

            $this->session->setUserIsManuallyGeolocated(false);
            $rightPath = $refererUrl;
        }

        $this->response->setRedirect($rightPath)->sendResponse();
        exit;
    }

    /**
     * Se new country id on quote country
     * @param $countryId
     */
    private function updateQuoteCountry($countryId) {
        $quote = $this->checkoutSessionFactory->create()->getQuote();
        if (!$quote) {
            return false;
        }

        try {
            $quoteBillingAddress = $quote->getBillingAddress();
            if ($quoteBillingAddress) {
                $quoteBillingAddress->setCountryId($countryId)->save();
            }

            $quoteShippingAddress = $quote->getShippingAddress();
            if ($quoteShippingAddress) {
                $quoteShippingAddress->setCountryId($countryId)->save();
            }
        } catch (\Exception $e) {
            $this->logger->error($e->getMessage());
        }

        return true;
    }

}
