<?php
/**
 * Config
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Geolocation\Plugin;

class Config
{

    const XML_PATH_GENERAL_COUNTRY_DEFAULT     = 'general/country/default';
    const XML_PATH_TAX_DEFAULT_COUNTRY     = 'tax/defaults/country';

    /**
     * @var \Drop\Geolocation\Model\Session
     */
    private $session;

    /**
     * Config constructor.
     *
     * @param \Magento\Framework\Session\SessionManager\Proxy $session
     */
    public function __construct(
        \Magento\Framework\Session\SessionManager\Proxy $session
    ) {
        $this->session = $session;
    }

    public function afterGetValue(
        \Magento\Framework\App\Config $subject,
        $result,
        $path,
        $scopeType = \Magento\Framework\App\Config\ScopeConfigInterface::SCOPE_TYPE_DEFAULT,
        $scopeCode = null
    )
    {
        if((($path == self::XML_PATH_GENERAL_COUNTRY_DEFAULT) || ($path == self::XML_PATH_TAX_DEFAULT_COUNTRY)) && (!empty($this->session->getCountryId()))) {
            return $this->session->getCountryId();
        }
        return $result;
    }

}
