<?php

namespace Drop\Geolocation\Controller\Rewrite\Store;

use Drop\Geolocation\Helper\Data;
use Drop\Geolocation\Model\Session;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\App\ActionInterface;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Session\Generic;
use Magento\Framework\Session\SidResolverInterface;
use Magento\Store\Api\StoreRepositoryInterface;
use Magento\Store\Api\StoreResolverInterface;
use Magento\Store\Model\Store;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Store\Model\StoreResolver;
use Magento\Store\Model\StoreSwitcher\ContextInterfaceFactory;
use Magento\Store\Model\StoreSwitcher\HashGenerator;
use Magento\Store\Model\StoreSwitcher\RedirectDataGenerator;

class Redirect extends \Magento\Store\Controller\Store\Redirect
{
    /**
     * @var StoreRepositoryInterface
     */
    private $storeRepository;

    /**
     * @var StoreResolverInterface
     */
    private $storeResolver;

    /**
     * @var HashGenerator
     */
    private $hashGenerator;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;
    /**
     * @var RedirectDataGenerator|null
     */
    private $redirectDataGenerator;
    /**
     * @var ContextInterfaceFactory|null
     */
    private $contextFactory;
    /**
     * @var Session
     */
    private Session $geoSession;
    /**
     * @var Data
     */
    private $helper;


    /**
     * @param Context $context
     * @param StoreRepositoryInterface $storeRepository
     * @param StoreResolverInterface $storeResolver
     * @param Session $session
     * @param SidResolverInterface $sidResolver
     * @param Session $geoSession
     * @param Data $helper
     */
    public function __construct(
        Context $context,
        StoreRepositoryInterface $storeRepository,
        StoreResolverInterface $storeResolver,
        Generic $session,
        SidResolverInterface $sidResolver,
        HashGenerator $hashGenerator,
        StoreManagerInterface $storeManager = null,
        ?RedirectDataGenerator $redirectDataGenerator = null,
        ?ContextInterfaceFactory $contextFactory = null,

        Session $geoSession,
        Data $helper
    ) {
        $this->geoSession = $geoSession;
        $this->helper = $helper;

        parent::__construct($context, $storeRepository, $storeResolver, $session, $sidResolver, $hashGenerator, $storeManager, $redirectDataGenerator, $contextFactory);
        $this->storeRepository = $storeRepository;
        $this->storeResolver = $storeResolver;
        $this->hashGenerator = $hashGenerator;
        $this->storeManager = $storeManager ?: ObjectManager::getInstance()->get(StoreManagerInterface::class);
        $this->redirectDataGenerator = $redirectDataGenerator
            ?: ObjectManager::getInstance()->get(RedirectDataGenerator::class);
        $this->contextFactory = $contextFactory
            ?: ObjectManager::getInstance()->get(ContextInterfaceFactory::class);
    }

    /**
     * @return ResponseInterface|\Magento\Framework\Controller\ResultInterface
     * @throws NoSuchEntityException
     */
    public function execute()
    {
        /** @var \Magento\Store\Model\Store $currentStore */
        $currentStore = $this->storeRepository->getById($this->storeResolver->getCurrentStoreId());
        $targetStoreCode = $this->_request->getParam(StoreResolver::PARAM_NAME);
        $fromStoreCode = $this->_request->getParam('___from_store');

        if ($targetStoreCode === null) {
            return $this->_redirect($currentStore->getBaseUrl());
        }

        try {
            /** @var Store $fromStore */
            $fromStore = $this->storeRepository->get($fromStoreCode);
            /** @var Store $targetStore */
            $targetStore = $this->storeRepository->get($targetStoreCode);
            $this->storeManager->setCurrentStore($targetStore);
            $encodedUrl = $this->_request->getParam(ActionInterface::PARAM_NAME_URL_ENCODED);
            $redirectData = $this->redirectDataGenerator->generate(
                $this->contextFactory->create(
                    [
                        'fromStore' => $fromStore,
                        'targetStore' => $targetStore,
                        'redirectUrl' => $this->_redirect->getRedirectUrl()
                    ]
                )
            );
            $query = [
                '___from_store' => $fromStore->getCode(),
                StoreResolverInterface::PARAM_NAME => $targetStoreCode,
                ActionInterface::PARAM_NAME_URL_ENCODED => $encodedUrl,
                'data' => $redirectData->getData(),
                'time_stamp' => $redirectData->getTimestamp(),
                'signature' => $redirectData->getSignature(),
            ];
            $arguments = [
                '_nosid' => true,
                '_query' => $query
            ];

            //Set locale to geolocation session
            $targetLocaleCode = $this->helper->getDefaultLocale(\Magento\Store\Model\ScopeInterface::SCOPE_STORE, $targetStoreCode);
            if(empty($targetLocaleCode)) {
                return $this->_redirect($currentStore->getBaseUrl());
            }

            $this->geoSession->setLocale($targetLocaleCode);

            $this->_redirect->redirect($this->_response, 'stores/store/switch', $arguments);
        } catch (NoSuchEntityException $e) {
            $this->messageManager->addErrorMessage(__("Requested store is not found ({$fromStoreCode})"));
            $this->_redirect->redirect($this->_response, $currentStore->getBaseUrl());
        }

        return null;
    }
}
