<?php
/**
 * Locale
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\Geolocation\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;

class Locale extends Action
{
    /**
     * @var \Magento\Framework\Controller\Result\Json
     */
    protected $resultJson;

    /**
     * @var \Magento\Framework\App\Request\Http
     */
    protected $request;

    /**
     * @var \Drop\Geolocation\Block\Geolocation
     */
    protected $geolocationBlock;

    /**
     * Locale constructor.
     * 
     * @param Context $context
     * @param \Drop\Geolocation\Block\Geolocation $geolocationBlock
     * @param \Magento\Framework\Controller\Result\Json $resultJson
     */
    public function __construct(
        Context $context,
        \Drop\Geolocation\Block\Geolocation $geolocationBlock,
        \Magento\Framework\Controller\Result\Json $resultJson
    )
    {
        parent::__construct($context);

        $this->request = $context->getRequest();
        $this->geolocationBlock = $geolocationBlock;
        $this->resultJson = $resultJson;
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface|void
     * @throws \Magento\Framework\Exception\LocalizedException
     *
     * @todo Utilizzare $this->getLayout()->createBlock("Magento\Store\Block\Switcher")->setTemplate('Magento_Store::switch/languages.phtml')->toHtml() dentro select-shipping-country.phtml
     * Trovare la maniera di settare/filtrare gli store utilizzati dentro Magento\Store\Block\Switcher e quindi renderizzati da switch/languages.phtml in base al country
     * Permettere l'aggiornamento in Ajax attraverso questo controller
     */
    public function execute()
    {

        if(!$this->request->isAjax()) {
            return false;
        }

        $countryId = $this->request->getParam('country_id');
        if(empty($countryId)) {
            return false;
        }

        $html = $this->geolocationBlock->getLocaleHtmlSelect($countryId);

        /** @var \Magento\Framework\Controller\Result\Json $resultJson */
        $resultJson = $this->resultFactory->create(\Magento\Framework\Controller\ResultFactory::TYPE_JSON);
        $resultJson->setData($html);
        return $resultJson;
    }

}
