<?php
/**
 * Author: Simone Monterubbiano <s.monterubbiano@drop.it>
 * Date: 12/03/2019
 * File name: Url.php
 * Project: GenderFirst
 */

namespace Drop\GenderFirst\Plugin;

use Magento\Framework\UrlInterface;

class Url {

    /**
     * @var \Drop\GenderFirst\Model\Gender
     */
    private $gender;
    /**
     * @var \Magento\Framework\Url
     */
    private $url;
    /**
     * @var \Magento\Catalog\Model\CategoryRepository
     */
    private $categoryRepository;
    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    private $storeManager;
    /**
     * @var \Magento\Framework\App\State
     */
    private $state;
    /**
     * @var \Magento\Framework\Url\ScopeResolverInterface
     */
    private $scopeResolver;

    /**
     * Url constructor.
     * @param \Drop\GenderFirst\Model\Gender $gender
     * @param \Magento\Framework\Url $url
     * @param \Magento\Catalog\Model\CategoryRepository $categoryRepository
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     */
    public function __construct(
        \Drop\GenderFirst\Model\Gender $gender,
        \Magento\Framework\Url $url,
        \Magento\Catalog\Model\CategoryRepository $categoryRepository,
        \Magento\Store\Model\StoreManagerInterface $storeManager
    )
    {
        $this->gender = $gender;
        $this->url = $url;
        $this->categoryRepository = $categoryRepository;
        $this->storeManager = $storeManager;
    }

//    public function beforeGetUrl(\Magento\Framework\Url $url, $route = '', $params = []){
//        // Only if is requested the home page
//        //if(empty($route)){
//
//        //if($route == "mui/index/render"){
//        if(empty($route)){
//            $newRoute = $this->gender->getGenderUrl();
//        }
//        return [$route,$params];
//    }

//    public function aroundGetUrl(UrlInterface $subject, \Closure $proceed, $routePath = null, $routeParams = null){
//
//        if($routePath === "mui/index/render") {
//            $routePath = $this->gender->getGenderUrl();
//        }
//
//        return $proceed($routePath, $routeParams);
//    }
}