<?php
/**
 * Author: Simone Monterubbiano <s.monterubbiano@drop.it>
 * Date: 25/02/2019
 * File name: Gender.php
 * Project: GenderFirst
 */
namespace Drop\GenderFirst\Observer;

class Gender implements \Magento\Framework\Event\ObserverInterface
{
    /**
     * @var \Magento\Framework\App\Request\Http
     */
    private $http;
    /**
     * @var \Magento\Framework\Registry
     */
    private $registry;
    /**
     * @var \Drop\GenderFirst\Model\Gender
     */
    private $gender;
    /**
     * @var \Magento\Catalog\Model\CategoryRepository
     */
    private $categoryRepository;
    /**
     * @var \Drop\GenderFirst\Helper\Data
     */
    private $helper;

    /**
     * Gender constructor.
     * @param \Drop\GenderFirst\Model\Gender $gender
     * @param \Drop\GenderFirst\Helper\Data $helper
     * @param \Magento\Framework\App\Request\Http $http
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Catalog\Model\CategoryRepository $categoryRepository
     */
    public function __construct(
        \Drop\GenderFirst\Model\Gender $gender,
        \Drop\GenderFirst\Helper\Data $helper,
        \Magento\Framework\App\Request\Http $http,
        \Magento\Framework\Registry $registry,
        \Magento\Catalog\Model\CategoryRepository $categoryRepository
    ){
        $this->http = $http;
        $this->registry = $registry;
        $this->gender = $gender;
        $this->categoryRepository = $categoryRepository;
        $this->helper = $helper;
    }

    public function execute(\Magento\Framework\Event\Observer $observer){
        // If is home page, set default gender
        if($this->http->getFullActionName()=="cms_index_index"){
            $this->gender->setGender($this->helper->getDefaultGender());
        }

        // Check if is a category page
        if($this->http->getFullActionName() == 'catalog_category_view'){
            $category = $this->registry->registry('current_category');

            foreach($category->getPathIds() as $catId):
                if($catId == $this->helper->getManCategoryId()){
                    $this->gender->setGender($this->helper->getDefaultGender());
                    $this->gender->setGenderUrl("");
                }

                if($catId == $this->helper->getWomanCategoryId()){
                    $category = $this->categoryRepository->get($catId);
                    $this->gender->setGender($this->helper->getWomanCategoryId());
                    $this->gender->setGenderUrl($this->helper->getRequestPath($category));
                }
            endforeach;
        }

        // Check if gender not set, set default gender
        if(!$this->gender->genderIsSet()){
            $this->gender->setGender($this->helper->getDefaultGender());
        }
    }


}