<?php
/**
 * Author: Simone Monterubbiano <s.monterubbiano@drop.it>
 * Date: 25/02/2019
 * File name: Cookie.php
 * Project: GenderFirst
 */
namespace Drop\GenderFirst\Model;

class Gender {

    private $sessionManager;

    /**
     * Gender constructor.
     * @param \Magento\Customer\Model\Session\Proxy $sessionManager
     */
    public function __construct(
        \Magento\Customer\Model\Session\Proxy $sessionManager
    ) {
        $this->sessionManager = $sessionManager;
    }

    /**
     * Get gender session value
     * @return null|string
     */
    public function getGender()
    {
        $this->sessionManager->start();
        return $this->sessionManager->getGender();
    }

    /**
     * @return mixed
     */
    public function getGenderUrl()
    {
        $this->sessionManager->start();
        return $this->sessionManager->getGenderUrl();
    }

    /**
     * Set gender session value
     * @param $value
     */
    public function setGender($value)
    {
        // Set session
        $this->sessionManager->start();
        $this->sessionManager->setGender($value);
    }

    /**
     * @param $value
     */
    public function setGenderUrl( $value){
        // Set session
        $this->sessionManager->start();
        $this->sessionManager->setGenderUrl($value);
    }

    /**
     * @return mixed
     */
    public function deleteGender()
    {
        $this->sessionManager->start();
        return $this->sessionManager->unsGender();
    }

    /**
     * Check if gender is set
     * @return bool
     */
    public function genderIsSet(){
        return (!empty($this->getGender()))?true:false;
    }
}