<?php
/**
 * Author: Simone Monterubbiano <s.monterubbiano@drop.it>
 * Date: 29/01/2019
 * File name: Data.php
 * Project: GenderFirst
 */
namespace Drop\GenderFirst\Helper;

use Magento\Framework\App\Helper\Context;

class Data extends \Magento\Framework\App\Helper\AbstractHelper{

    /**
     * Data constructor.
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param Context $context
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        Context $context
    )
    {
        $this->scopeConfig = $scopeConfig;
        parent::__construct( $context );
    }

    public function getConfig($config_path)
    {
        return $this->scopeConfig->getValue(
            $config_path,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        );
    }

    public function getManCategoryId(){
        return $this->getConfig("genderfirst/configuration/man_category_id");
    }

    public function getWomanCategoryId(){
        return $this->getConfig("genderfirst/configuration/woman_category_id");
    }

    public function getDefaultGender(){
        return $this->getConfig("genderfirst/configuration/default_gender");
    }

    public function getRequestPath(\Magento\Catalog\Model\Category\Interceptor $category){
        $exploded = explode("/",$category->getUrl());
        return end($exploded);
    }
}