<?php

namespace Drop\GELProximity\Test\Unit\Plugin\Magento\Checkout\Block;

use Drop\GELProximity\Helper\Data;
use Drop\GELProximity\Logger\Logger;
use Drop\GELProximity\Plugin\Block\Checkout\LayoutProcessor as PluginLayoutProcessor;
use Magento\Checkout\Block\Checkout\LayoutProcessor;
use Magento\Checkout\Model\Session;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Locale\Resolver;
use Magento\Framework\Serialize\Serializer\Json;
use Magento\Framework\TestFramework\Unit\Helper\ObjectManager;
use Drop\GELProximity\Api\Helper\MaskedQuoteIdToQuoteIdInterface;
use Drop\GELProximity\Api\Helper\QuoteIdToMaskedQuoteIdInterface;
use PHPUnit\Framework\TestCase;
use Psr\Log\LoggerInterface;

/**
 * Class LayoutProcessorTest
 * @package Drop\GELProximity\Test\Unit\Plugin\Magento\Checkout\Block
 */
class LayoutProcessorTest extends TestCase
{
    /**
     * @var PluginLayoutProcessor
     */
    protected $pluginProcessor;

    /**
     * @var LayoutProcessor
     */
    protected $originalProcessor;

    /**
     * @var Data
     */
    protected $helper;

    /**
     * Setup dependency before testing
     */
    protected function setUp(): void
    {
        $objectManager = new ObjectManager($this);
        //This object will not be mocked, otherwise helper will not work
        $context = $objectManager->getObject(Context::class);
        //Mock checkout session quote ID
        $checkoutSession = $this->createMock(Session::class);
        $checkoutSession
            ->method('getQuoteId')
            ->willReturn(1);
        //Mock helper object's methods
        $this->helper = $this->getMockBuilder(Data::class)
            ->setConstructorArgs([
                $context,
                $this->createMock(Resolver::class),
                $this->createMock(QuoteIdToMaskedQuoteIdInterface::class),
                $this->createMock(MaskedQuoteIdToQuoteIdInterface::class),
                $this->createMock(Json::class),
                $this->createMock(Logger::class)
            ])
            ->setMethodsExcept(['addGELButton'])
            ->getMock();
        $this->helper
            ->method('isModuleEnabled')
            ->willReturn(true);

        $this->originalProcessor = $this->createMock(LayoutProcessor::class);
        $this->pluginProcessor = $this->getMockBuilder(PluginLayoutProcessor::class)
            ->setConstructorArgs([
                $this->helper,
                $checkoutSession,
                $this->createMock(LoggerInterface::class)
            ])
            ->setMethodsExcept(['afterProcess'])
            ->getMock();
    }

    /**
     * Test the main plugin method
     */
    public function testAfterProcess(): void
    {
        $this->assertSame(
            $this->getLayoutData(),
            $this->pluginProcessor->afterProcess(
                $this->originalProcessor,
                $this->getLayoutData()
            )
        );
    }


    /**
     * Get mock layout data for testing
     *
     * @return array
     */
    private function getLayoutData(): array
    {
        return [
            'components' => [
                'checkout' => [
                    'children' => [
                        'steps' => [
                            'children' => [
                                'shipping-step' => [
                                    'children' => [
                                        'shippingAddress' => [
                                            'children' => [
                                                'shipping-address-fieldset' => [
                                                    'children' => [
                                                        'firstname' => '',
                                                        'lastname' => '',
                                                        'taxvat' => '',
                                                        'street' => [],
                                                        'zip' => 12345,
                                                        'region' => ''
                                                    ]
                                                ]
                                            ]
                                        ]
                                    ]
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];
    }
}
