<?php

namespace Drop\GELProximity\Test\Unit\Helper;

use Drop\GELProximity\Helper\Data;
use Drop\GELProximity\Logger\Logger;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Locale\Resolver;
use Magento\Framework\Serialize\Serializer\Json;
use Drop\GELProximity\Api\Helper\MaskedQuoteIdToQuoteIdInterface;
use Drop\GELProximity\Api\Helper\QuoteIdToMaskedQuoteIdInterface;
use PHPUnit\Framework\TestCase;

/**
 * Class DataTest
 * @package Drop\GELProximity\Test\Unit\Helper
 */
class DataTest extends TestCase
{
    /**
     * @var Data
     */
    protected $helper;

    /**
     * Setup dependency before testing
     * @constructor
     */
    protected function setUp(): void
    {
        $this->helper = $this
            ->getMockBuilder(Data::class)
            ->setConstructorArgs([
                $this->createMock(Context::class),
                $this->createMock(Resolver::class),
                $this->createMock(QuoteIdToMaskedQuoteIdInterface::class),
                $this->createMock(MaskedQuoteIdToQuoteIdInterface::class),
                new Json(),
                $this->createMock(Logger::class)
            ])
            ->setMethodsExcept([
                'maskQuoteId',
                'unmaskQuoteId',
                'serializeArray',
                'unserializeToArray'
            ])
            ->getMock();
    }

    /**
     * Test method for @see Data::maskQuoteId()
     *
     * @test
     * @throws NoSuchEntityException
     */
    public function testMaskQuoteId(): void
    {
        $this->assertSame(
            '',
            $this->helper->maskQuoteId(1)
        );
    }

    /**
     * Test method for @see Data::unmaskQuoteId()
     *
     * @test
     * @throws NoSuchEntityException
     */
    public function testUnmaskQuoteId(): void
    {
        $this->assertSame(
            0,
            $this->helper->unmaskQuoteId('d82uoodjawlkòj2')
        );
    }

    /**
     * Test method for @see Data::serializeArray()
     *
     * @test
     */
    public function testSerializeArray(): void
    {
        $this->assertEquals(
            '{"data":1,"serialize":true,"helper":"Drop\\\\GELProximity\\\\Helper\\\\Data"}',
            $this->helper->serializeArray([
                'data' => 1,
                'serialize' => true,
                'helper' => Data::class
            ])
        );
    }

    /**
     * Test method for @see Data::unserializeToArray()
     *
     * @test
     */
    public function testUnserializeToArray(): void
    {
        $this->assertEquals(
            [
                'data' => 1,
                'serialize' => true,
                'helper' => Data::class
            ],
            $this->helper->unserializeToArray(
                '{"data":1,"serialize":true,"helper":"Drop\\\\GELProximity\\\\Helper\\\\Data"}'
            )
        );
    }
}
