<?php

namespace Drop\GELProximity\Cron;

use Drop\GELProximity\Api\CronInterface;
use Drop\GELProximity\Service\ShipService;

/**
 * Class ShipOrders
 * @package Drop\GELProximity\Cron
 */
class ShipOrders implements CronInterface
{
    /**
     * @var ShipService
     */
    protected $service;

    /**
     * ShipOrders constructor.
     * @param ShipService $service
     */
    public function __construct(ShipService $service)
    {
        $this->service = $service;
    }

    /**
     * Cron method that load a collection of orders with the Processing GEL status
     * and make a call to ship them
     *
     * {@inheritDoc}
     */
    public function execute(): void
    {
        $this->service->run();
    }
}
