<?php

namespace Drop\GELProximity\Api\Service\Processors;

use Drop\GELProximity\Api\Data\GelShipmentInterface;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Sales\Model\Order;

/**
 * Interface OrderProcessorInterface
 * @package Drop\GELProximity\Api\Service\Processors
 */
interface OrderProcessorInterface
{
    /**
     * Process the array that will be sent to GEL server to confirm the order
     *
     * @param Order $order
     * @param bool $isReturn
     * @return array
     */
    public function processConfirm(Order $order, bool $isReturn = false): array;

    /**
     * Process the array that will be sent to GEL server to retrieve the tracking status
     *
     * @param Order $order
     * @param GelShipmentInterface $gelShipment
     * @return array
     */
    public function processTracking(Order $order, GelShipmentInterface $gelShipment): array;

    /**
     * Change the order status to Sent to GEL
     *
     * @param Order $order
     * @throws CouldNotSaveException
     */
    public function sentToGEL(Order $order): void;

    /**
     * Ship the given order and sends the email notify to the customer
     *
     * @param Order $order
     * @param int $shipmentStatus
     * @throws CouldNotSaveException
     */
    public function ship(Order $order, int $shipmentStatus): void;

    /**
     * Add tracking entity to the order's shipment and notify the customer
     *
     * Tracking array must have 2 items inside:
     *      [number]            -> The tracking number
     *      [statusDescription] -> Description for the current tracking status
     *
     * @param Order $order
     * @param array $tracking
     * @throws CouldNotSaveException
     */
    public function track(Order $order, array $tracking): void;

    /**
     * Complete the given order
     *
     * @param Order $order
     * @throws CouldNotSaveException
     */
    public function complete(Order $order): void;
}
