<?php

namespace Drop\GELProximity\Test\Unit\Model\Service;

use Drop\GELProximity\Api\Service\Responses\DefaultResponseInterface;
use Drop\GELProximity\Helper\Data;
use Drop\GELProximity\Model\Service\GelService;
use Drop\GELProximity\Model\Service\Responses\ResponseObjectFactory;
use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Customer\Model\Session as CustomerSession;
use PHPUnit\Framework\TestCase;

/**
 * Class GelServiceTest
 * @package Drop\GELProximity\Test\Unit\Model\Service
 */
class GelServiceTest extends TestCase
{
    /**
     * @var GelService
     */
    protected $gelService;

    /**
     * Setup dependency before testing
     *
     * @constructor
     */
    protected function setUp(): void
    {
        $this->gelService = $this
            ->getMockBuilder(GelService::class)
            ->setConstructorArgs([
                $this->createMock(CheckoutSession::class),
                $this->createMock(Data::class),
                $this->createMock(ResponseObjectFactory::class),
                $this->createMock(CustomerSession::class)
            ])
            ->setMethodsExcept(['removePickupPoint'])
            ->getMock();
    }

    /**
     * Test method for @see GelService::removePickupPoint()
     *
     * @test
     * @return void
     */
    public function testRemovePickupPoint(): void
    {
        $this->assertInstanceOf(
            DefaultResponseInterface::class,
            $this->gelService->removePickupPoint()
        );
    }
}
