<?php

namespace Drop\GELProximity\Setup;

use Drop\GELProximity\Api\Data\GelShipmentInterface;
use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UpgradeSchemaInterface;

/**
 * Class UpgradeSchema
 * @package Drop\GELProximity\Setup
 */
class UpgradeSchema implements UpgradeSchemaInterface
{
    /**
     * {@inheritDoc}
     */
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();

        if (version_compare($context->getVersion(), '1.1.0') < 0) {
            $this->addAdditionalPickupPointDataColumn($setup);
        }

        if (version_compare($context->getVersion(), '1.2.0') < 0) {
            $this->addIsReturnColumn($setup);
        }

        $setup->endSetup();
    }

    /**
     * @param SchemaSetupInterface $setup
     * @return void
     */
    protected function addAdditionalPickupPointDataColumn(SchemaSetupInterface $setup): void
    {
        $table = $setup->getTable(GelShipmentInterface::TABLE_NAME);
        if ($setup->tableExists($table)) {
            $connection = $setup->getConnection();
            $connection->addColumn(
                $table,
                GelShipmentInterface::ADDITIONAL_PICKUP_POINT_DATA,
                [
                    'type' => Table::TYPE_TEXT,
                    'nullable' => true,
                    'comment' => 'Additional data of the selected pickup point from GEL Proximity',
                    'after' => GelShipmentInterface::CURRENCY
                ]
            );
        }
    }

    /**
     * @param SchemaSetupInterface $setup
     * @return void
     */
    protected function addIsReturnColumn(SchemaSetupInterface $setup): void
    {
        $table = $setup->getTable(GelShipmentInterface::TABLE_NAME);
        if ($setup->tableExists($table)) {
            $connection = $setup->getConnection();
            $connection->addColumn(
                $table,
                GelShipmentInterface::IS_RETURN,
                [
                    'type' => Table::TYPE_BOOLEAN,
                    'nullable' => false,
                    'default' => 0,
                    'comment' => 'Tells if the order is a RMA',
                    'after' => GelShipmentInterface::CURRENCY
                ]
            );
        }
    }
}
