<?php

namespace Drop\GELProximity\Api\Service\Responses;

/**
 * Interface CurrentPickupPointInterface
 * @package Drop\GELProximity\Api\Service\Responses
 */
interface CurrentPickupPointInterface extends DefaultResponseInterface
{
    /**
     * @const
     */
    public const KEY_PICKUP_POINT_DATA = 'pickup_point_data';

    /**
     * Return the pickup point data as a JSON
     * @return string|null
     */
    public function getPickupPointData(): ?string;

    /**
     * Set pickup point data as a JSON string
     *
     * @param string $data
     * @return $this
     */
    public function setPickupPointData(string $data): self;
}
