define([
    'jquery',
    'Magento_Ui/js/model/messageList',
    'loader',
    'GelLib',
    'mage/translate',
    'mage/storage',
    'mage/url'
], function ($, messageList, loader,  GelLib, $t, storage, url) {
    'use strict';

    $.widget('mage.gelWidget', {
        options: {
            quoteId: '',
            orderId: '',
            apiKey: '',
            merchantCode: '',
            reference: '',
            redirectMode: '',
            urlRedirectOk: '',
            urlRedirectCancel: '',
            locale: '',
            urlEndUser: '',
            pickupPointData: '',
            gelSDK: {},
        },
        selectors: {
            gelContainer: '.block.gel-widget',
            gelButton: '.btn.open-gel-widget',
            removeGelButton: '.btn.remove-pickup-point',
            returnAddressText: '#pickup-point-address',
            returnAddressInput: '#return_address',
            gelButtonContainer: '.gel-button-container',
            gelRemoveContainer: '.gel-remove-container'
        },

        /**
         * Initialize the script
         *
         * @private
         */
        _create: function () {
            this._initGel();
            url.setBaseUrl(BASE_URL);
            $(this.selectors.gelButton).on('click', this.selectPickupPoint.bind(this));
            $(this.selectors.removeGelButton).on('click', this.removePickupPoint.bind(this));
            $(this.selectors.gelContainer).loader();
        },

        /**
         * Action event for the button which will open the gel-end-user
         *
         * @param {Event} event
         * @event
         */
        selectPickupPoint: function (event) {
            this.gelSDK.createUIModal({
                callbackOk: (response) => this.addPickupPoint(response),
                callbackKo: () => {}
            });
        },

        /**
         * Action event which will remove the selected pickup point
         *
         * @param {Event} event
         * @event
         */
        removePickupPoint: function (event) {
            this._startLoader(this.selectors.gelContainer);
            let serviceUrl = url.build('rest/V1/gel/pickupPoint/rma/remove'),
                payload = {};
            storage.post(
                serviceUrl,
                JSON.stringify(payload)
            ).then(response => {
                if (response.success) {
                    //Remove pickup point selection
                    this.options.pickupPointData = null;
                    $(this.selectors.returnAddressText).text(this.pickupSelection());
                    $(this.selectors.returnAddressInput).val(this.pickupSelection());
                    //Switch buttons
                    $(this.selectors.gelButtonContainer).show();
                    $(this.selectors.gelRemoveContainer).hide();
                    messageList.addSuccessMessage({message: response.message})
                    //Add success message
                } else {
                    //Add error message
                    messageList.addErrorMessage({message: response.message});
                }
                this._stopLoader(this.selectors.gelContainer);
            });
        },

        /**
         * Callback action when the pickup point get selected
         *
         * @param {JSON} callbackData
         * @returns {Promise<void>}
         */
        addPickupPoint: function (callbackData) {
            this._startLoader(this.selectors.gelContainer);
            let serviceUrl = url.build('rest/V1/gel/pickupPoint/rma/add'),
                payload = {
                    data: callbackData,
                    orderId: this.options.orderId,
                    quoteId: this.options.quoteId
                };
            storage.post(
                serviceUrl,
                JSON.stringify(payload)
            ).then(response => {
                if (response.success) {
                    //Add pickup point selection
                    this.options.pickupPointData = JSON.stringify(callbackData);
                    $(this.selectors.returnAddressText).text(this.pickupSelection());
                    $(this.selectors.returnAddressInput).val(this.pickupSelection());
                    //Switch buttons
                    $(this.selectors.gelButtonContainer).hide();
                    $(this.selectors.gelRemoveContainer).show();
                    //Add success message
                    messageList.addSuccessMessage({message: response.message});
                } else {
                    //Add error message
                    messageList.addErrorMessage({message: response.message});
                }
                this._stopLoader(this.selectors.gelContainer);
            });
        },

        /**
         * Returns the selected pickup point
         *
         * @returns {string}
         */
        pickupSelection: function () {
            let pickupPointData = JSON.parse(this.options.pickupPointData);
            if (pickupPointData !== null) {
                return '%1, %2 (%3), %4, %5'
                    .replace('%1', pickupPointData.address)
                    .replace('%2', pickupPointData.city)
                    .replace('%3', pickupPointData.department)
                    .replace('%4', pickupPointData.zipCode)
                    .replace('%5', pickupPointData.country);
            }
            return '';
        },

        /**
         * Init GelSDK object
         *
         * @private
         */
        _initGel: function () {
            //Init the GelSDK object with requested data
            const postData = this._initRequestObject();
            this.gelSDK = new GelLib.GelSDK(postData);
        },

        /**
         * Creates an object containing the POST object that will be sent to GEL API
         *
         * @returns {{apiKey, merchantCode, reference, redirectMode, urlRedirectOk, urlRedirectCancel, locale, urlEndUser}}
         * @private
         */
        _initRequestObject: function () {
            return {
                apiKey: this.options.apiKey,
                merchantCode: this.options.merchantCode,
                reference: this.options.reference,
                redirectMode: this.options.redirectMode,
                urlRedirectOk: this.options.urlRedirectOk,
                urlRedirectCancel: this.options.urlRedirectCancel,
                locale: this.options.locale,
                urlEndUser: this.options.urlEndUser,
                isReturnOrder: true
            };
        },

        /**
         * Start the loader on the given HTML selector
         *
         * @param {HTMLElement} selector
         * @private
         */
        _startLoader: function (selector) {
            $(selector).loader('show');
        },

        /**
         * Stop the loader on the given HTML selector
         *
         * @param {HTMLElement} selector
         * @private
         */
        _stopLoader: function (selector) {
            $(selector).loader('hide');
        }
    });
    return $.mage.gelWidget;
})
