<?php

namespace Drop\GELProximity\Test\Unit\Model\Carrier;

use Drop\GELProximity\Helper\Data;
use Drop\GELProximity\Model\Carrier\GELProximity;
use Magento\Checkout\Model\Session;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Quote\Api\CartRepositoryInterface;
use Magento\Quote\Model\Quote\Address\RateRequest;
use Magento\Quote\Model\Quote\Address\RateResult\ErrorFactory;
use Magento\Quote\Model\Quote\Address\RateResult\Method;
use Magento\Quote\Model\Quote\Address\RateResult\MethodFactory;
use Magento\Shipping\Model\Rate\Result;
use Magento\Shipping\Model\Rate\ResultFactory;
use Magento\Framework\TestFramework\Unit\Helper\ObjectManager;
use PHPUnit\Framework\TestCase;
use Psr\Log\LoggerInterface;

/**
 * Class GELProximityTest
 * @package Drop\GELProximity\Test\Unit\Model\Carrier
 */
class GELProximityTest extends TestCase
{
    /**
     * @var GELProximity
     */
    protected $gelProximityCarrier;

    /**
     * Setup dependency before testing
     *
     * @constructor
     */
    protected function setUp(): void
    {
        $objectManager = new ObjectManager($this);
        //Mock factory objects because they throw exception when creating the new mocked instance
        $methodFactory = $this
            ->getMockBuilder(MethodFactory::class)
            ->disableOriginalConstructor()
            ->getMock();
        $methodFactory->method('create')->willReturn($objectManager->getObject(Method::class));
        $resultFactory = $this
            ->getMockBuilder(ResultFactory::class)
            ->disableOriginalConstructor()
            ->getMock();
        $resultFactory->method('create')->willReturn($objectManager->getObject(Result::class));

        $this->gelProximityCarrier = $this
            ->getMockBuilder(GELProximity::class)
            ->setConstructorArgs([
                $this->createMock(ScopeConfigInterface::class),
                $this->createMock(ErrorFactory::class),
                $this->createMock(LoggerInterface::class),
                $resultFactory,
                $methodFactory,
                $this->createMock(Session::class),
                $this->createMock(CartRepositoryInterface::class),
                $this->createMock(Data::class)
            ])
            ->setMethodsExcept(['collectRates'])
            ->getMock();
    }

    /**
     * Test method for @see GELProximity::collectRates()
     *
     * @test
     * @return void
     */
    public function testCollectRates(): void
    {
        $rateRequest = $this->createMock(RateRequest::class);
        //First assertion with the carrier disabled
        $this->assertFalse(
            $this->gelProximityCarrier->collectRates($rateRequest)
        );
        //Second assertion with the carrier active
        $this->gelProximityCarrier->method('isActive')->willReturn(true);
        $this->assertInstanceOf(
            Result::class,
            $this->gelProximityCarrier->collectRates($rateRequest)
        );
    }
}
