<h1 align="center">
    <img alt="Drop Logo Animated" title="Drop Logo Animated" src="https://www.Drop.ts.it/wp-content/themes/Drop/resources/assets/build/img/loading-Drop.gif">
</h1>
<h1 align="center">GEL Proximity Integration Module</h1>
<p align="center">This module is used to integrate the GEL Proximity shipment inside Magento 2 (2.2.9 version)</p>

---
## Download
First thing you need is an OAuth consumer key-secret pair, that you can request to Drop after purchasing the module.<br>
Once you got the credentials, you need to run the following commands from the document root of your Magento application:
* `composer config bitbucket-oauth.bitbucket.org [your-consumer-key] [your-consumer-secret]`
* `composer config repositories.gel-proximity "{\"type\":\"git\",\"url\":\"https://bitbucket.org/Dropts/magento2-gel-proximity.git\"}"`
* `composer require Drop/module-gel-proximity:1.2.0`

---
## Installation
Once downloaded the module via composer package manager, you need to enable and compile it.<br>
To do it, run the following commands from your project's document root:
* `bin/magento module:enable Drop_GELProximity`
* `bin/magento setup:upgrade`
* `bin/magento setup:di:compile`
* `bin/magento setup:static-content:deploy [...locales][...themes]`

---
## Module Configuration
After installing, you need to enable and configure the module properly.<br>
To do so, follow the instructions below which will explain all the configuration available:

* ### Main Configuration
  ![Configuration Group](docs/images/configuration.png "Configuration Group")
  + **Enabled**: possibility to enable/disable the full functionality for the module;
  + **Environment**: choose which environment will be used, will be affected the credentials in the next group;
  + **Button Text**: text of the GEL button in checkout and RMA page.
  + **Cart Items Limit**: limit with which the shipping method will be considered disabled.
  + **Returns Status**: select with a list of possible status in which the returns will be processed.
  + **Debug mode**: it will enable/disable verbose writing in the custom log file.

* ### Credentials (Test and Production)
  ![Credentials Group](docs/images/credentials.png "Credentials Group")
  + **API Key**: secret code provided by GEL Proximity to call their pickup point page;
  + **API Key S2S**: secret code provided by GEL Proximity to call their server API;
  + **Merchant Code**: merchant code provided by GEL Proximity, required to do API calls to their server and open the pickup point page.
  + **GEL Widget URL**: URL of the widget that will be opened by the button in checkout and RMA page.
  + **URL GEL Widget Server**: URL of GEL API Server to just confirm the order (or the RMA).
  + **URL GEL API Server**: URL of GEL API Server to make all the requests, except for order confirmation one.

* ### Error Report
  ![Error Report Group](docs/images/error_report.png "Error Report Group")
  + **Enabled**: possibility to enable/disable the functionality which sends an email if the cron encounters an error;
  + **Send To**: email addresses (separated by a comma) that will receive the error report.

---
## Shipping Method Configuration
Here you'll find all the configuration fields for the GEL Proximity shipping method.<br>
The method is disabled by default, and his shipping cost is 0 because useless, it will be defined by the selected pickup point.
![Shipping Method Section](docs/images/shipping_method.png "Shipping Method Section")

---
## Cron Jobs Description
Inside the module, you'll find 3 different cron jobs; here's the description for each of them:
* **Ship Orders**: calls a service which sends a request to GEL server for each order in state `Processing GEL` to confirm it and start the shipment;
* **Track Orders**: processes all the orders with the status `Shipped`, sending a request to GEL server that will respond with the track and shipment status;
  in case of shipment not completed, the service will just attach the tracking object to the order, otherwise the order will be changed to `Complete` status;
* **Clean Shipments**: deletes all the GEL shipments in the custom table (`gel_proximity_shipment`) that no longer have a quote and an order.
* **Sync Orders Status**: loops all the orders with the Pending GEL status that have an invoice and have already been paid (PayPal orders case), and change their status to Processing GEL.
* **Process Returns**: loops all the returns in status Pending (configurable in backoffice) and sent to GEL order data about it to approve the return.

---
## CLI Commands Description
For each of the above cron jobs, there is also a console command: below you'll find the services listed above, and their corresponding CLI commands:
* Ship Orders -> `bin/magento gel:orders:ship`
* Track Orders -> `bin/magento gel:orders:track`
* Clean Shipments -> `bin/magento gel:shipments:clean`
* Sync Orders status -> `bin/magento gel:orders-status:sync`
* Process Returns -> `bin/magento gel:returns:process`

To get the complete list of commands, you can use the following commands:
+ `bin/magento list | grep -i gel` -> this will list all the Magento CLI commands, filtered by `gel` word;
+ `bin/magento gel` -> this will throw the exception for the wrong command, but listing all the `gel` possible commands (little trick).

---
## Contacts
If you need any kind of help with the module, feel free to contact one of the email addresses below:
* Serafino Davide -> **_dserafino@Drop.ts.it_**
* Husu Diego -> **_dhusu@Drop.ts.it_**

---
![Drop Logo Static](docs/images/logo.svg "Drop Logo Static")
