<?php

namespace Drop\GELProximity\Console\Command;

use Drop\GELProximity\Console\AbstractCommand;
use Drop\GELProximity\Service\CleanService;
use Exception;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Console\Cli;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class CleanShipments
 * @package Drop\GELProximity\Console\Command
 */
class CleanShipments extends AbstractCommand
{
    /**
     * @const
     * CLI command name
     */
    public const NAME = 'gel:shipments:clean';

    /**
     * {@inheritDoc}
     */
    protected function configure()
    {
        $this
            ->setName(self::NAME)
            ->setDescription('Deletes all the GEL shipments that hasn\'t got an order and a quote anymore.');
        parent::configure();
    }

    /**
     * Command method that deletes all the shipments without quote and order references
     *
     * {@inheritDoc}
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int
     */
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->setAreaCode();
        try {
            /**
             * We should avoid using the object manager directly
             * but with DI throws an exception of "Area code not set"
             * during upgrade/dependency compilation
             */
            $objectManager = ObjectManager::getInstance();
            $service = $objectManager->get(CleanService::class);
            $shipmentsDeleted = $service->run();
        } catch (Exception $e) {
            //Probably a remote case, but we'll output it anyway
            $output->writeln('<error>' . $e->getMessage() . '</error>');
            return Cli::RETURN_FAILURE;
        }
        //Notice the user of the shipments deleted
        if ($shipmentsDeleted > 0) {
            $output->writeln(
                sprintf(
                    '<info>Deleted %s GEL shipments.</info>',
                    $shipmentsDeleted
                )
            );
        } else {
            $output->writeln('<info>No shipments were deleted.</info>');
        }
        return Cli::RETURN_SUCCESS;
    }
}
