<?php

namespace Drop\GELProximity\Model\ResourceModel;

use Drop\GELProximity\Api\Data\GelShipmentInterface;
use Drop\GELProximity\Api\GelShipmentResourceInterface;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;
use Magento\Framework\Model\ResourceModel\Db\Context;

/**
 * Class GelShipment
 * @package Drop\GELProximity\Model\ResourceModel
 */
class GelShipment extends AbstractDb implements GelShipmentResourceInterface
{
    /**
     * @var string
     */
    protected $_eventPrefix = 'gel_shipment_resource';

    /**
     * @var string
     */
    protected $_eventObject = 'resource';

    /**
     * GelShipment constructor.
     * @param Context $context
     * @param null $connectionName
     */
    // phpcs:ignore Generic.CodeAnalysis.UselessOverridingMethod.Found
    public function __construct(Context $context, $connectionName = null)
    {
        parent::__construct($context, $connectionName);
    }

    /**
     * {@inheritDoc}
     */
    protected function _construct()
    {
        $this->_init(
            GelShipmentInterface::TABLE_NAME,
            GelShipmentInterface::ENTITY_ID
        );
    }
}
