<?php

namespace Drop\GELProximity\Model;

use Magento\Framework\ObjectManagerInterface;

/**
 * Class GelShipmentFactory
 * Factory class for @see GelShipment
 * @package Drop\GELProximity\Model
 * @factory
 */
class GelShipmentFactory
{
    /**
     * @var ObjectManagerInterface
     */
    protected $_objectManager;

    /**
     * GelShipmentFactory constructor.
     * @param ObjectManagerInterface $objectManager
     */
    public function __construct(ObjectManagerInterface $objectManager)
    {
        $this->_objectManager = $objectManager;
    }

    /**
     * Create config model
     *
     * @param array $data
     * @return GelShipment
     */
    public function create(array $data = []): GelShipment
    {
        return $this->_objectManager->create(
            GelShipment::class,
            $data
        );
    }
}
