<?php

namespace Drop\GELProximity\Cron;

use Drop\GELProximity\Api\CronInterface;
use Drop\GELProximity\Service\ShipReturnsService;

/**
 * Class ShipRma
 * @package Drop\GELProximity\Cron
 */
class ShipReturns implements CronInterface
{
    /**
     * @var ShipReturnsService
     */
    protected $service;

    /**
     * ShipRma constructor.
     * @param ShipReturnsService $service
     */
    public function __construct(ShipReturnsService $service)
    {
        $this->service = $service;
    }

    /**
     * {@inheritDoc}
     */
    public function execute(): void
    {
        $this->service->run();
    }
}
