<?php

namespace Drop\GELProximity\Api\Service;

/**
 * Interface ServiceInterface
 * @package Drop\GELProximity\Api\Service
 */
interface ServiceInterface
{
    /**
     * This method has to be implemented in each service class
     * Returns the total order/shipments processed
     *
     * @service
     * @return int
     */
    public function run(): int;

    /**
     * Method that will be executed before each service to check the availability of the service
     *
     * @service
     * @return bool
     */
    public function canBeExecuted(): bool;
}
