<?php

namespace Drop\GELProximity\Plugin\Helper;

use Drop\GELProximity\Helper\Data;
use Magento\Checkout\Model\Session;
use Magento\Framework\Event\ManagerInterface;
use Magento\Paypal\Helper\Checkout;

/**
 * Class PaypalCancelOrder
 * @package Drop\GELProximity\Plugin\Helper
 * @plugin
 */
class PaypalCancelOrder
{
    /**
     * @var Data
     */
    protected $helper;

    /**
     * @var Session
     */
    protected $checkoutSession;

    /**
     * @var ManagerInterface
     */
    protected $eventManager;

    /**
     * PaypalCancelOrder constructor.
     * @param Data $helper
     * @param Session $checkoutSession
     * @param ManagerInterface $eventManager
     */
    public function __construct(
        Data $helper,
        Session $checkoutSession,
        ManagerInterface $eventManager
    ) {
        $this->helper = $helper;
        $this->checkoutSession = $checkoutSession;
        $this->eventManager = $eventManager;
    }

    /**
     * Plugin method that fires the Magento event that Magento itself
     * has forgotten to fire in the Paypal method HostedPro
     *
     * @param Checkout $subject
     * @param bool $orderCancelled
     * @return bool
     */
    public function afterCancelCurrentOrder(
        Checkout $subject,
        bool $orderCancelled
    ): bool {
        if ($this->helper->isModuleEnabled()) {
            //I think there's no other method to get the order at this point, anyway i don't like it
            $order = $this->checkoutSession->getLastRealOrder();

            //Debug
            $this->helper->logDebug('[PLUGIN_PAYPALCANCELORDER] Firing magento event order_cancel_after for order ' . $order->getId());

            //Fire the order cancel event that Magento itself has forgotten
            $this->eventManager->dispatch('order_cancel_after', ['order' => $order]);

            //Debug
            $this->helper->logDebug('--- [PLUGIN_PAYPALCANCELORDER] Event successfully ran.');
        } else {
            //Debug
            $this->helper->logDebug('[PLUGIN_PAYPALCANCELORDER] Module not enabled: skipping.');
        }
        return $orderCancelled;
    }
}
