<?php

namespace Drop\GELProximity\Model\Service\Responses;

use Drop\GELProximity\Api\Service\Responses\DefaultResponseInterface;
use Magento\Framework\Api\AbstractExtensibleObject;
use Magento\Framework\Phrase;

/**
 * Class DefaultResponse
 * @package Drop\GELProximity\Model\Service\Responses
 * @responseObject
 */
class DefaultResponse extends AbstractExtensibleObject implements DefaultResponseInterface
{
    /**
     * {@inheritDoc}
     */
    public function getSuccess(): bool
    {
        return $this->_get(self::KEY_SUCCESS);
    }

    /**
     * {@inheritDoc}
     */
    public function setSuccess(bool $success): DefaultResponseInterface
    {
        $this->setData(self::KEY_SUCCESS, $success);
        return $this;
    }

    /**
     * {@inheritDoc}
     */
    public function getMessage(): Phrase
    {
        return $this->_get(self::KEY_MESSAGE);
    }

    /**
     * {@inheritDoc}
     */
    public function setMessage(string $message): DefaultResponseInterface
    {
        $this->setData(self::KEY_MESSAGE, __($message));
        return $this;
    }
}
