<?php

namespace Drop\GELProximity\Model\ResourceModel\GelShipment;

use Drop\GELProximity\Api\Data\GelShipmentInterface;
use Drop\GELProximity\Model\GelShipment;
use Drop\GELProximity\Model\ResourceModel\GelShipment as GelShipmentResource;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;

/**
 * Class Collection
 * @package Drop\GELProximity\Model\ResourceModel\GelShipment
 */
class Collection extends AbstractCollection
{
    /**
     * @var string
     */
    protected $_idFieldName = GelShipmentInterface::ENTITY_ID;
    /**
     * @var string
     */
    protected $_eventPrefix = 'gel_shipment_collection';

    /**
     * @var string
     */
    protected $_eventObject = 'gel_shipment_collection';

    /**
     * Define resource model
     *
     * @return void
     */
    protected function _construct(): void
    {
        $this->_init(
            GelShipment::class,
            GelShipmentResource::class
        );
    }
}
