<?php

namespace Drop\GELProximity\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class Environment
 * @package Drop\GELProximity\Model\Config\Source
 */
class Environment implements OptionSourceInterface
{
    /**
     * @const
     */
    public const TEST_ENVIRONMENT = 'test';
    public const PRODUCTION_ENVIRONMENT = 'production';

    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray(): array
    {
        return [
            [
                'value' => self::TEST_ENVIRONMENT,
                'label' => __('Test')
            ],
            [
                'value' => self::PRODUCTION_ENVIRONMENT,
                'label' => __('Production')
            ]
        ];
    }

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray(): array
    {
        return [
            self::TEST_ENVIRONMENT => __('Test'),
            self::PRODUCTION_ENVIRONMENT => __('Production')
        ];
    }
}
