<?php

namespace Drop\GELProximity\Api\Data;

/**
 * Interface GelShipmentInterface
 * @package Drop\GELProximity\Api\Data
 */
interface GelShipmentInterface
{
    /**
     * @const
     */
    public const TABLE_NAME = 'gel_proximity_shipment';

    /**
     * @const
     */
    public const ENTITY_ID = 'entity_id';

    /**
     * @const
     */
    public const PICKUP_POINT_ID = 'pickup_point_id';

    /**
     * @const
     */
    public const COST = 'cost';

    /**
     * @const
     */
    public const CURRENCY = 'currency';

    /**
     * @const
     */
    public const IS_RETURN = 'is_return';

    /**
     * @const
     */
    public const ADDITIONAL_PICKUP_POINT_DATA = 'additional_pickup_point_data';

    /**
     * @const
     */
    public const QUOTE_REFERENCE = 'quote_reference';

    /**
     * @const
     */
    public const QUOTE_ID = 'quote_id';

    /**
     * @const
     */
    public const ORDER_ID = 'order_id';

    /**
     * @const
     */
    public const EXTERNAL_ORDER_ID = 'external_order_id';

    /**
     * @const
     */
    public const CREATED_AT = 'created_at';

    /**
     * @const
     */
    public const UPDATED_AT = 'updated_at';

    /**
     * @return int|string|null
     */
    public function getEntityId();

    /**
     * @param int|string $entityId
     * @return void
     */
    public function setEntityId($entityId);

    /**
     * @return int|string|null
     */
    public function getId();

    /**
     * @return int|string|null
     */
    public function getPickupPointId();

    /**
     * @param int $pickupPointId
     * @return $this
     */
    public function setPickupPointId(int $pickupPointId): self;

    /**
     * @return string|null
     */
    public function getCost();

    /**
     * @param float|null $cost
     * @return $this
     */
    public function setCost(?float $cost): self;

    /**
     * @return string|null
     */
    public function getCurrency();

    /**
     * @param string|null $currency
     * @return $this
     */
    public function setCurrency(?string $currency): self;

    /**
     * @return int|null
     */
    public function getIsReturn();

    /**
     * @param bool $isReturn
     * @return $this
     */
    public function setIsReturn(bool $isReturn): self;

    /**
     * @return string|null
     */
    public function getAdditionalPickupPointData();

    /**
     * @param string $additionalPickupPointData
     * @return $this
     */
    public function setAdditionalPickupPointData(string $additionalPickupPointData): self;

    /**
     * @return string|null
     */
    public function getQuoteReference();

    /**
     * @param string $quoteReference
     * @return $this
     */
    public function setQuoteReference(string $quoteReference): self;

    /**
     * @return int|string|null
     */
    public function getQuoteId();

    /**
     * @param int $quoteId
     * @return $this
     */
    public function setQuoteId(int $quoteId): self;

    /**
     * @return int|string|null
     */
    public function getOrderId();

    /**
     * @param int $orderId
     * @return $this
     */
    public function setOrderId(int $orderId): self;

    /**
     * @return int|string|null
     */
    public function getExternalOrderId();

    /**
     * @param int $externalOrderId
     * @return $this
     */
    public function setExternalOrderId(int $externalOrderId): self;

    /**
     * @return string|null
     */
    public function getCreatedAt();

    /**
     * @param string $createdAt
     * @return $this
     */
    public function setCreatedAt(string $createdAt): self;

    /**
     * @return string|null
     */
    public function getUpdatedAt();

    /**
     * @param string $updatedAt
     * @return $this
     */
    public function setUpdatedAt(string $updatedAt): self;
}
