<?php

namespace Drop\GELProximity\Helper;

use Drop\GELProximity\Api\Helper\QuoteIdToMaskedQuoteIdInterface;
use Magento\Quote\Api\CartRepositoryInterface;
use Magento\Quote\Model\QuoteIdMaskFactory;
use Magento\Quote\Model\ResourceModel\Quote\QuoteIdMask;

/**
 * Class QuoteIdToMaskedQuoteId
 * @package Drop\GELProximity\Helper
 */
class QuoteIdToMaskedQuoteId implements QuoteIdToMaskedQuoteIdInterface
{
    /**
     * @var QuoteIdMaskFactory
     */
    protected $quoteIdMaskFactory;

    /**
     * @var CartRepositoryInterface
     */
    protected $cartRepository;

    /**
     * @var QuoteIdMask
     */
    protected $quoteIdMaskResource;

    /**
     * QuoteIdToMaskedQuoteId constructor.
     * @param QuoteIdMaskFactory $quoteIdMaskFactory
     * @param CartRepositoryInterface $cartRepository
     * @param QuoteIdMask $quoteIdMaskResource
     */
    public function __construct(
        QuoteIdMaskFactory $quoteIdMaskFactory,
        CartRepositoryInterface $cartRepository,
        QuoteIdMask $quoteIdMaskResource
    ) {
        $this->quoteIdMaskFactory = $quoteIdMaskFactory;
        $this->cartRepository = $cartRepository;
        $this->quoteIdMaskResource = $quoteIdMaskResource;
    }

    /**
     * {@inheritDoc}
     */
    public function execute(int $quoteId): string
    {
        /* Check the quote exists to avoid database constraint issues */
        $this->cartRepository->get($quoteId);

        $quoteIdMask = $this->quoteIdMaskFactory->create();
        $this->quoteIdMaskResource->load($quoteIdMask, $quoteId, 'quote_id');
        return $quoteIdMask->getMaskedId() ?? '';
    }
}
