<?php

namespace Drop\GELProximity\Console\Command;

use Drop\GELProximity\Console\AbstractCommand;
use Drop\GELProximity\Service\TrackService;
use Exception;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Console\Cli;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class TrackOrders
 * @package Drop\GELProximity\Console\Command
 */
class TrackOrders extends AbstractCommand
{
    /**
     * @const
     * CLI command name
     */
    public const NAME = 'gel:orders:track';

    /**
     * {@inheritDoc}
     */
    protected function configure()
    {
        $this
            ->setName(self::NAME)
            ->setDescription('Loads a collection of orders in Sent to GEL and Shipped GEL statuses and tracks them.');
        parent::configure();
    }

    /**
     * Command method that load a collection of order with the Sent to GEL status
     * and make a call to track and change their status based on the current tracking status
     *
     * {@inheritDoc}
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int
     */
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->setAreaCode();
        try {
            /**
             * We should avoid using the object manager directly
             * but with DI throws an exception of "Area code not set"
             * during upgrade/dependency compilation
             */
            $objectManager = ObjectManager::getInstance();
            $service = $objectManager->get(TrackService::class);
            $ordersTracked = $service->run();
        } catch (Exception $e) {
            //Probably a remote case, but we'll output it anyway
            $output->writeln('<error>' . $e->getMessage() . '</error>');
            return Cli::RETURN_FAILURE;
        }
        //Notice the user of the orders tracked
        if ($ordersTracked > 0) {
            $output->writeln(
                sprintf(
                    '<info>Tracked %s orders.</info>',
                    $ordersTracked
                )
            );
        } else {
            $output->writeln('<info>No orders were tracked.</info>');
        }
        return Cli::RETURN_SUCCESS;
    }
}
