<?php

namespace Drop\GELProximity\Console\Command;

use Drop\GELProximity\Console\AbstractCommand;
use Drop\GELProximity\Service\ShipService;
use Exception;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Console\Cli;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class ShipOrders
 * @package Drop\GELProximity\Console\Command
 */
class ShipOrders extends AbstractCommand
{
    /**
     * @const
     * CLI command name
     */
    public const NAME = 'gel:orders:ship';

    /**
     * {@inheritDoc}
     */
    protected function configure()
    {
        $this
            ->setName(self::NAME)
            ->setDescription('Loads a collection of orders in Processing GEL status and ship them.');
        parent::configure();
    }

    /**
     * Command method that load a collection of orders with the Processing GEL status
     * and make a call to ship them
     *
     * {@inheritDoc}
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int
     */
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->setAreaCode();
        try {
            /**
             * We should avoid using the object manager directly
             * but with DI throws an exception of "Area code not set"
             * during upgrade/dependency compilation
             */
            $objectManager = ObjectManager::getInstance();
            $service = $objectManager->get(ShipService::class);
            $ordersShipped = $service->run();
        } catch (Exception $e) {
            //Probably a remote case, but we'll output it anyway
            $output->writeln('<error>' . $e->getMessage() . '</error>');
            return Cli::RETURN_FAILURE;
        }
        //Notice the user of the orders shipped
        if ($ordersShipped > 0) {
            $output->writeln(
                sprintf(
                    '<info>Shipped %s orders.</info>',
                    $ordersShipped
                )
            );
        } else {
            $output->writeln('<info>No orders were shipped.</info>');
        }
        return Cli::RETURN_SUCCESS;
    }
}
