<?php

namespace Drop\GELProximity\Block\Rma;

use Drop\GELProximity\Api\ConfigPathInterface;
use Drop\GELProximity\Helper\Data;
use Magento\Framework\View\Element\Template;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Sales\Model\Order;

/**
 * Class Widget
 * @package Drop\GELProximity\Block\Rma
 */
class Widget extends Template
{
    /**
     * @var Data
     */
    protected $helper;

    /**
     * @var OrderRepositoryInterface
     */
    protected $orderRepository;

    /**
     * @var Order|null
     */
    protected $order = null;

    /**
     * Widget constructor.
     * @param Data $helper
     * @param OrderRepositoryInterface $orderRepository
     * @param Template\Context $context
     * @param array $data
     */
    public function __construct(
        Data $helper,
        OrderRepositoryInterface $orderRepository,
        Template\Context $context,
        array $data = []
    ) {
        $this->helper = $helper;
        $this->orderRepository = $orderRepository;
        parent::__construct($context, $data);
    }

    /**
     * Returns the encoded string with the KnockOut component to be rendered
     *
     * @return string
     */
    public function getMageInit(): string
    {
        $order = $this->getOrder();
        return $this->helper->serializeArray(
            [
                '*' => [
                    'Drop_GELProximity/js/view/rma/gel-proximity-widget' => [
                        'quoteId' => $order !== null ? $order->getQuoteId() : '',
                        'orderId' => $order !== null ? $order->getId() : '',
                        'apiKey' => $this->helper->getConfigValue(ConfigPathInterface::API_KEY_CONFIG_PATH),
                        'merchantCode' => $this->helper->getConfigValue(ConfigPathInterface::MERCHANT_CODE_CONFIG_PATH),
                        'reference' => $this->buildReference(),
                        'redirectMode' => $this->helper->getConfigValue(ConfigPathInterface::REDIRECT_MODE_CONFIG_PATH),
                        'urlRedirectOk' => $this->_urlBuilder->getUrl(
                            $this->helper->getConfigValue(ConfigPathInterface::PATH_REDIRECT_OK_CONFIG_PATH)
                        ),
                        'urlRedirectCancel' => $this->_urlBuilder->getUrl(
                            $this->helper->getConfigValue(ConfigPathInterface::PATH_REDIRECT_CANCEL_CONFIG_PATH)
                        ),
                        'locale' => $this->helper->getLocale(),
                        'urlEndUser' => $this->helper->getConfigValue(ConfigPathInterface::URL_END_USER_CLIENT_CONFIG_PATH)
                    ],
                ],
            ]
        );
    }

    /**
     * Returns the text of the GEL widget button
     *
     * @return string
     */
    public function getGELButtonText(): string
    {
        return $this->helper->getConfigValue(ConfigPathInterface::BUTTON_TEXT_CONFIG_PATH);
    }

    /**
     * Retrieves the current processing order
     *
     * @return Order|null
     */
    public function getOrder(): ?Order
    {
        if ($this->order === null) {
            $orderId = $this->getRequest()->getParam('order_id');
            if ($orderId !== null) {
                $this->order = $this->orderRepository->get($orderId);
            }
        }
        return $this->order;
    }

    /**
     * Builds the reference which will be sent to GEL Proximity
     *
     * @return string
     */
    protected function buildReference(): string
    {
        $order = $this->getOrder();
        if ($order !== null) {
            return sprintf(
                'R%s_%s',
                $order->getQuoteId(),
                date('Ymd')
            );
        }
    }
}
