<?php

namespace Drop\GELProximity\Api\Service;

use Drop\GELProximity\Api\Service\Responses\CurrentPickupPointInterface;
use Drop\GELProximity\Api\Service\Responses\DefaultResponseInterface;

/**
 * Interface GelServiceInterface
 * @package Drop\GELProximity\Api\Service
 * @webapi
 */
interface GelServiceInterface
{
    /**
     * Webapi method to remove the selected pickup point
     *
     * @return \Drop\GELProximity\Api\Service\Responses\DefaultResponseInterface
     * @api
     * @POST
     */
    public function removePickupPoint(): DefaultResponseInterface;

    /**
     * Webapi method to add the requested pickup point to the session
     *
     * @param string[] $data
     * @return \Drop\GELProximity\Api\Service\Responses\DefaultResponseInterface
     * @api
     * @POST
     */
    public function addPickupPoint(array $data): DefaultResponseInterface;

    /**
     * Webapi method to retrieve the current pickup point data from checkout session
     *
     * @return \Drop\GELProximity\Api\Service\Responses\CurrentPickupPointInterface
     * @api
     * @GET
     */
    public function getCurrentPickupPoint(): CurrentPickupPointInterface;

    /**
     * Webapi method to add the chosen pickup point inside customer session
     *
     * @param string[] $data
     * @param int|null $orderId
     * @return \Drop\GELProximity\Api\Service\Responses\DefaultResponseInterface
     * @api
     * @POST
     */
    public function addRMAPickupPoint(array $data, ?int $orderId): DefaultResponseInterface;

    /**
     * Webapi method to remove the previously chosen pickup point from the session
     *
     * @return \Drop\GELProximity\Api\Service\Responses\DefaultResponseInterface
     * @api
     * @POST
     */
    public function removeRMAPickupPoint(): DefaultResponseInterface;
}
