<?php

namespace Drop\GELProximity\Plugin\Model;

use Drop\GELProximity\Model\Carrier\GELProximity;
use Magento\Checkout\Api\Data\ShippingInformationInterface;
use Magento\Checkout\Model\Session;
use Magento\Checkout\Model\ShippingInformationManagement;
use Magento\Framework\Exception\InputException;

/**
 * Class ValidatePickupPoint
 * @package Drop\GELProximity\Plugin\Model
 */
class ValidatePickupPoint
{
    /**
     * @var Session
     */
    protected $checkoutSession;

    /**
     * ValidatePickupPoint constructor.
     * @param Session $checkoutSession
     */
    public function __construct(Session $checkoutSession)
    {
        $this->checkoutSession = $checkoutSession;
    }

    /**
     * Server side validation for pickup point selection
     * If the selected shipping method is GEL Proximity and there isn't a pickup point,
     * throws an exception
     *
     * It's a really bad ways to validate, we should use the shipping-mixin instead,
     * but it's not working with the customization done by the customer website
     *
     * @param ShippingInformationManagement $subject
     * @param int $cartId
     * @param ShippingInformationInterface $shippingInformation
     * @throws InputException
     */
    public function beforeSaveAddressInformation(
        ShippingInformationManagement $subject,
        int $cartId,
        ShippingInformationInterface $shippingInformation
    ): void {
        if (
            $shippingInformation->getShippingCarrierCode() === GELProximity::CARRIER_CODE &&
            $this->checkoutSession->getData('gel_pickup_point_id') === null
        ) {
            throw new InputException(
                __('In order to proceed, you must choose a pickup point.')
            );
        }
    }
}
